package com.ejie.ab59.control.expedientes;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.RelExpDir;
import com.ejie.ab59.model.expedientes.TiposDireccion;
import com.ejie.ab59.service.expedientes.DatosDireccionesService;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/datosDirecciones")

public class DatosDireccionesController {

	private static final Logger logger = LoggerFactory.getLogger(DatosDireccionesController.class);

	@Autowired
	private DatosDireccionesService datosDireccionesService;

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones Bean que contiene la informacion a modificar.
	 * @return DatosDirecciones Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody DatosDirecciones edit(@RequestBody RelExpDir relExpDir,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		DatosDirecciones datosDirecciones = relExpDir.getDatosDirecciones();
		datosDirecciones.setUsuarioUltmodificacion(usuario.getUsuario());
		datosDirecciones.setIdentificadorEstablecimiento(datosDirecciones.getIdentificadorEstablecimientoUno()
				+ datosDirecciones.getIdentificadorEstablecimientoDos()
				+ datosDirecciones.getIdentificadorEstablecimientoTres());

		if (relExpDir.getIdDireccion() != null) {

			datosDirecciones = this.datosDireccionesService.updateUbicacion(datosDirecciones);
		} else {
			TiposDireccion tipoDireccion = new TiposDireccion();
			tipoDireccion.setIdTipoDireccion(Constantes.UBICACION_ACTIVIDAD);
			datosDirecciones.setTipoDireccion(tipoDireccion);
			datosDirecciones.setUsuarioRegistro(usuario.getUsuario());
			relExpDir.setUsuarioRegistro(usuario.getUsuario());
			relExpDir.setDatosDirecciones(datosDirecciones);

			relExpDir = this.datosDireccionesService.insertUbicacion(relExpDir);
		}
		DatosDireccionesController.logger.info("[PUT] : Datos Direcciones actualizada correctamente");
		return datosDirecciones;
	}

	@RequestMapping(value = "/buscarEstablecimiento/{numeroRegistro}", method = RequestMethod.GET)
	public @ResponseBody DatosDirecciones buscarEstablecimiento(@PathVariable String numeroRegistro) {
		DatosDireccionesController.logger.info("[GET] : Buscar Establecimiento AB63");

		return this.datosDireccionesService.buscarEstablecimiento(numeroRegistro);
	}

}
