package com.ejie.ab59.control.estadosProSan;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.comun.SeguridadAplicacion;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.propuestasSancion.EstadosProSan;
import com.ejie.ab59.service.procedimientos.ProcedimientosService;
import com.ejie.ab59.service.propuestasSancion.EstadosProSanService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * EstadosProSanController  
 * 
 *  
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/estadosProSan")

public class EstadosProSanController {

	private static final Logger logger = LoggerFactory.getLogger(EstadosProSanController.class);

	@Autowired
	private EstadosProSanService estadosProSanService;
	@Autowired
	private ProcedimientosService procedimientosService;

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idRelExpDir
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return RelExpDir Bean eliminado.
	 */
	@RequestMapping(value = "/cargarCombo", method = RequestMethod.GET)
	public @ResponseBody List<EstadosProSan> cargarCombo(@ModelAttribute EstadosProSan estadosProSan) {
		EstadosProSanController.logger.info("[GET - find_ALL] : Obtener EstadosProSan para cargar un combo");
		Procedimientos procedimiento = new Procedimientos();

		if (estadosProSan.getIdDireccion() != null) {
			if (estadosProSan.getIdDireccion() == Constantes.ID_TURISMO_DIRECCION) {
				procedimiento = this.procedimientosService.obtenerProcedimientos(Constantes.ID_TURISMO_DIRECCION);
				estadosProSan.setProcedimiento(procedimiento);
			} else if (estadosProSan.getIdDireccion() == Constantes.ID_COMERCIO_DIRECCION) {
				procedimiento = this.procedimientosService.obtenerProcedimientos(Constantes.ID_COMERCIO_DIRECCION);
				estadosProSan.setProcedimiento(procedimiento);
			} else {
				return new ArrayList<EstadosProSan>();
			}
		}

		return this.estadosProSanService.cargarCombo(estadosProSan);
	}

	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		EstadosProSanController.logger.info("[GET - View] : estados de la propuesta de sancion");
		String idDireccion = SeguridadAplicacion.precargarDireccion();
		Procedimientos procedimiento = null;
		String idProcedimiento = "";

		if (!"".contentEquals(idDireccion)) {
			procedimiento = this.procedimientosService.obtenerProcedimientos(Integer.parseInt(idDireccion));
		}

		if (procedimiento != null) {
			idProcedimiento = String.valueOf(procedimiento.getIdProcedimiento());
		}

		model.addAttribute("procedimientoPrecargado", idProcedimiento);
		return "estadosProSan";
	}

	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<EstadosProSan> filter(
			@RequestJsonBody(param = "filter") EstadosProSan filterEstadosProSan,
			@RequestJsonBody TableRequestDto tableRequestDto) {

		EstadosProSanController.logger.info("[POST - filter] : Obtener EstadosProSan");

		return this.estadosProSanService.filter(filterEstadosProSan, tableRequestDto);
	}

	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody EstadosProSan edit(@RequestBody EstadosProSan estadoProSan,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		EstadosProSan estadoProSanAux = this.estadosProSanService.update(estadoProSan);
		EstadosProSanController.logger.info("[PUT] : EstadoProSan actualizado correctamente");
		return estadoProSanAux;
	}

	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody EstadosProSan add(@RequestBody EstadosProSan estadoProSan,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		Calendar cal = Calendar.getInstance();
		estadoProSan.setFechaRegistro(cal.getTime());
		estadoProSan.setUsuarioRegistro(usuario.getUsuario());

		EstadosProSan estadoProSanAux = this.estadosProSanService.add(estadoProSan);
		EstadosProSanController.logger.info("[POST] : EstadoProSan insertado correctamente");
		return estadoProSanAux;
	}

	@RequestMapping(value = "/{idEstadoProSan}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody EstadosProSan remove(@PathVariable Integer idEstadoProSan,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		EstadosProSan estadoProSan = new EstadosProSan();

		estadoProSan.setIdEstadoProSan(idEstadoProSan);

		this.estadosProSanService.remove(estadoProSan);
		EstadosProSanController.logger.info("[DELETE] : EstadoProSan borrado correctamente");
		return estadoProSan;
	}

	@RequestMapping(value = "/{idEstadoProSan}", method = RequestMethod.GET)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody EstadosProSan find(@PathVariable Integer idEstadoProSan,
			@ModelAttribute(value = "usuario") Usuario usuario) {

		EstadosProSan estadoProSan = new EstadosProSan();

		estadoProSan.setIdEstadoProSan(idEstadoProSan);

		EstadosProSan estadoProSanAux = this.estadosProSanService.find(estadoProSan);
		EstadosProSanController.logger.info("[GET] : EstadoProSan");
		return estadoProSanAux;
	}

	@RequestMapping(value = "/comprobarPorDefecto/{idProcedimiento}", method = RequestMethod.GET)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Integer comprobarPorDefecto(@PathVariable Integer idProcedimiento) {

		Integer countPorDefecto = this.estadosProSanService.comprobarPorDefecto(idProcedimiento);
		return countPorDefecto;
	}

	@RequestMapping(value = "/findPorDefecto/{idDireccion}", method = RequestMethod.GET)
	public @ResponseBody EstadosProSan findPorDefecto(@PathVariable Integer idDireccion) {
		EstadosProSanController.logger.info("[GET - find_ALL] : Obtener EstadosProSan para cargar un combo");
		Procedimientos procedimiento = new Procedimientos();

		if (idDireccion == Constantes.ID_TURISMO_DIRECCION) {
			procedimiento = this.procedimientosService.obtenerProcedimientos(Constantes.ID_TURISMO_DIRECCION);
		} else if (idDireccion == Constantes.ID_COMERCIO_DIRECCION) {
			procedimiento = this.procedimientosService.obtenerProcedimientos(Constantes.ID_COMERCIO_DIRECCION);
		}

		return this.estadosProSanService.findPorDefecto(procedimiento);
	}

}
