package com.ejie.ab59.control.busquedaPropuestasSancion;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.SeguridadAplicacion;
import com.ejie.ab59.comun.UtilUsuario;

/**
 * 
 *  
 *
 */
@SessionAttributes("usuario")
@Controller
@RequestMapping(value = "/busquedapropuestassancion")

public class BusquedaPropuestasSancionController {

	private static final Logger logger = LoggerFactory.getLogger(BusquedaPropuestasSancionController.class);

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(HttpServletRequest httpRequest, Model model) {
		BusquedaPropuestasSancionController.logger.info("[GET - View] : Bsqueda Propuestas Sancion");

		Authentication aut = SecurityContextHolder.getContext().getAuthentication();
		BusquedaPropuestasSancionController.logger.info("autotenticacinn:getAuthentication" + aut);

		Usuario usuario = UtilUsuario.getUsuario(aut, httpRequest);
		model.addAttribute("usuario", usuario);

		boolean esPerfilConsulta = SeguridadAplicacion.esPerfilConsulta();
		model.addAttribute("esPerfilConsulta", esPerfilConsulta);

		return "busquedaPropuestasSancion";
	}
}
