package com.ejie.ab59.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab59.model.pagos.SituacionExpediente;
import com.ejie.ab59.service.SituacionExpedienteService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * SituacionExpedienteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/situacionexpediente")

public class SituacionExpedienteController {

	private static final Logger logger = LoggerFactory.getLogger(SituacionExpedienteController.class);

	@Autowired
	private SituacionExpedienteService situacionExpedienteService;

	@RequestMapping(value = "/{idSituacionExpediente}", method = RequestMethod.GET)
	public @ResponseBody SituacionExpediente get(@PathVariable Integer idSituacionExpediente) {
		SituacionExpediente situacionExpediente = new SituacionExpediente();
		situacionExpediente.setIdSituacionExpediente(idSituacionExpediente);
		situacionExpediente = this.situacionExpedienteService.find(situacionExpediente);
		SituacionExpedienteController.logger.info("[GET - findBy_PK] : Obtener SituacionExpediente por PK");
		return situacionExpediente;
	}

	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<SituacionExpediente> getAll(
			@ModelAttribute SituacionExpediente filterSituacionExpediente) {
		SituacionExpedienteController.logger.info("[GET - findAllLike] : Obtener SituacionExpediente por filtro");
		return this.situacionExpedienteService.findAllLike(filterSituacionExpediente, null, false);
	}

	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<SituacionExpediente> filter(
			@RequestJsonBody(param = "filter") SituacionExpediente filterSituacionExpediente,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		SituacionExpedienteController.logger.info("[POST - filter] : Obtener SituacionExpedientes");
		return this.situacionExpedienteService.filter(filterSituacionExpediente, tableRequestDto, false);
	}
}
