package com.ejie.ab59.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab59.model.pagos.Liquidaciones;
import com.ejie.ab59.service.LiquidacionesService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * LiquidacionesController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/liquidaciones")

public class LiquidacionesController {

	private static final Logger logger = LoggerFactory.getLogger(LiquidacionesController.class);

	@Autowired
	private LiquidacionesService liquidacionesService;

	@RequestMapping(value = "/{idLiquidacionPago}", method = RequestMethod.GET)
	public @ResponseBody Liquidaciones get(@PathVariable Integer idLiquidacionPago) {
		Liquidaciones liquidaciones = new Liquidaciones();
		liquidaciones.setIdLiquidacionPago(idLiquidacionPago);
		liquidaciones = this.liquidacionesService.find(liquidaciones);
		LiquidacionesController.logger.info("[GET - findBy_PK] : Obtener Liquidaciones por PK");
		return liquidaciones;
	}

	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Liquidaciones> getAll(@ModelAttribute Liquidaciones filterLiquidaciones) {
		LiquidacionesController.logger.info("[GET - find_ALL] : Obtener Liquidaciones por filtro");
		return this.liquidacionesService.findAll(filterLiquidaciones, null);
	}

	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Liquidaciones edit(@RequestBody Liquidaciones liquidaciones) {
		Liquidaciones liquidacionesAux = this.liquidacionesService.update(liquidaciones);
		LiquidacionesController.logger.info("[PUT] : Liquidaciones actualizado correctamente");
		return liquidacionesAux;
	}

	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Liquidaciones add(@RequestBody Liquidaciones liquidaciones) {
		Liquidaciones liquidacionesAux = this.liquidacionesService.add(liquidaciones);
		LiquidacionesController.logger.info("[POST] : Liquidaciones insertado correctamente");
		return liquidacionesAux;
	}

	@RequestMapping(value = "/{idLiquidacionPago}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Liquidaciones remove(@PathVariable Integer idLiquidacionPago) {
		Liquidaciones liquidaciones = new Liquidaciones();
		liquidaciones.setIdLiquidacionPago(idLiquidacionPago);
		this.liquidacionesService.remove(liquidaciones);
		LiquidacionesController.logger.info("[DELETE] : Liquidaciones borrado correctamente");
		return liquidaciones;
	}

	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<Liquidaciones> filter(
			@RequestJsonBody(param = "filter") Liquidaciones filterLiquidaciones,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		LiquidacionesController.logger.info("[POST - filter] : Obtener Liquidacioness");
		return this.liquidacionesService.filter(filterLiquidaciones, tableRequestDto, false);
	}

}
