<%@page pageEncoding="UTF-8" contentType="text/html; charset=UTF-8"%>
<%@include file="/WEB-INF/includeTemplate.inc"%>	
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>

<section>
	<div id="contenedor" class="container">	
	<div id="id_capa"></div>
	
	<div id="acordeonBusqueda" class="rup_accordion">
		<h1 class="expandH1_acordeonBusqueda"><a><span><spring:message code="busquedaSanciones.criterios"/></span></a>&nbsp;<i class="" aria-hidden="true"></i></h1>
		<div class="form-group accordion_height_auto">
			<form id="formBusquedaSanciones">
				<div class="row">
					<div class="col-xs-3 form-group">
						<label for="numExpediente"><spring:message code="busquedaSanciones.numExpediente"/></label>
						<input id="numExpediente" name="expediente.folderNumber" type="text" class="form-control" style="text-transform:uppercase">
					</div>
					<div class="col-xs-9 form-group">
						<label for="tituloExpediente"><spring:message code="busquedaSanciones.tituloExpediente"/></label>
						<input type="text" id="tituloExpediente" name="expediente.titulo" class="form-control"  style="text-transform:uppercase">
					</div>
				</div>
				<input type="hidden" id="idTipoEmpTer" name="tipoEmpTer"/>
				<div class="row mb-4">
					<div class="col-xs-2 form-group">
						<div class="radio">
							<input type="radio" id="tipoEmpresaFiltro"  name="tipoEmpTer" value="1" />
							<label for="tipoEmpresaFiltro" class="bold"><spring:message code="busquedaSanciones.empresa"/></label>
						</div>
					</div>
					<div class="col-xs-2 form-group">
						<div class="radio">
							<input type="radio" id="tipoTerceroFiltro" name="tipoEmpTer" value="2" />
							<label for="tipoTerceroFiltro" class="bold"><spring:message code="busquedaSanciones.tercero"/></label>
						</div>
					</div>
				</div>
				
				<div id="rowEmpresa" class="row" hidden="true">
					<div class="col-xs-3 form-group">
						<label for="nombreEmpresa"><spring:message code="busquedaSanciones.nombreEmpresa"/></label>
						<input id="nombreEmpresa" type="text" class="form-control" style="text-transform:uppercase">
					</div>
					<div class="col-xs-3 form-group">
						<label for="cifEmpresa"><spring:message code="busquedaSanciones.cifEmpresa"/></label>
						<input id="cifEmpresa" type="text" class="form-control" style="text-transform:uppercase">
					</div>
				</div>
				
				<div id="rowTercero" class="row" hidden="true">
					<div class="col-xs-3 form-group">
						<label for="nombreTitular"><spring:message code="busquedaSanciones.nombreTitular"/></label>
						<input id="nombreTitular" type="text" class="form-control" style="text-transform:uppercase">
					</div>
					<div class="col-xs-3 form-group">
						<label for="apellido1Titular"><spring:message code="busquedaSanciones.apellido1Titular"/></label>
						<input id="apellido1Titular" type="text" class="form-control" style="text-transform:uppercase">
					</div>
					<div class="col-xs-3 form-group">
						<label for="apellido2Titular"><spring:message code="busquedaSanciones.apellido2Titular"/></label>
						<input id="apellido2Titular" type="text" class="form-control" style="text-transform:uppercase">
					</div>
					<div class="col-xs-3 form-group">
						<label for="dniTitular"><spring:message code="busquedaSanciones.dniTitular"/></label>
						<input id="dniTitular" type="text" class="form-control" style="text-transform:uppercase">
					</div>
				</div>
				
				<div class="card">
					<div class="card-header"><spring:message code="ubicacionActividad"/></div>
					<div class="card-body">
						<div class="row">
							<div class="col-xs-4 form-group">
								<label for="idProvincia"><spring:message code="ubicacion.provincia"/></label>
								<div class="input-group">
									<input id="codigoProvincia" class="form-control" style="text-align:center" onkeyup="buscarComboProvincia();"/>
									<span class="input-group-addon">&nbsp;&nbsp;</span>
									<select name="expediente.datosDirecciones.provincia.id" id="idProvincia" class="form-control"></select>
								</div>
							</div>
							<div class="col-xs-4 form-group">
								<label for="idMunicipio"><spring:message code="ubicacion.municipio"/></label>
								<div class="input-group">
									<input id="codigoMunicipio" class="form-control" style="text-align:center" onkeyup="buscarComboMunicipio();"/>
									<span class="input-group-addon">&nbsp;&nbsp;</span>
									<select name="expediente.datosDirecciones.municipio.id" id="idMunicipio" class="form-control"></select>
								</div>
							</div>
							<div class="col-xs-4 form-group">
								<label for ="idLocalidad"><spring:message code="ubicacion.localidad"/></label>
								<div class="input-group">
									<span class="input-group-addon">&nbsp;&nbsp;</span>
									<select name="expediente.datosDirecciones.localidad.id" id="idLocalidad" class="form-control"></select>
								</div>
								
							</div>
						</div>
						<div class="row">
							
							<div class="col-xs-5 form-group">
								<label for="calle"><spring:message code="ubicacion.direccion"/></label>
								<div class="input-group">
									<input id="calle" name="expediente.datosDirecciones.direccion" type="text" class="form-control"   style="text-transform:uppercase">
								</div>
							</div>
							<div class="col-xs-5 form-group">
								<div class="input-group">
									<div class="col-xs-3 form-group">
										<label for="numero"><spring:message code="ubicacion.numero"/></label>
										<input id="numero" name="expediente.datosDirecciones.numero" type="text" class="form-control">
									</div>
									<div class="col-xs-3 form-group">
										<label for="escalera"><spring:message code="ubicacion.escalera"/></label>
										<input id="escalera" name="expediente.datosDirecciones.escalera" type="text" class="form-control"   style="text-transform:uppercase">
									</div>
									<div class="col-xs-3 form-group">
										<label for="piso"><spring:message code="ubicacion.piso"/></label>
										<input id="piso" name="expediente.datosDirecciones.piso" type="text" class="form-control"   style="text-transform:uppercase">
									</div>
									<div class="col-xs-3 form-group">
										<label for="letra"><spring:message code="ubicacion.letra"/></label>
										<input id="letra" name="expediente.datosDirecciones.letra" type="text" class="form-control"   style="text-transform:uppercase">
									</div>
								</div>
							</div>
							<div class="col-xs-2 form-group">
								<label for="codigoPostal"><spring:message code="ubicacion.codigoPostal"/></label>
								<input id="codigoPostal" name="expediente.datosDirecciones.codigoPostal" type="text" class="form-control">
							</div>
						</div>								
					</div>
				</div>
				
				<div class="row">
					<div class="form-group col-xs-4">
						<div class="row">
							<label for="importeSancionFiltro" class="fechaFiltro"><spring:message code="busquedaSanciones.importeSancion" /></label>
						</div>
						<input type="text" id="importeSancionDesde" name="importeSancionDesde" class="form-control rangoFiltro" /><span>&nbsp;&nbsp;<spring:message code="busquedaSanciones.hasta" /></span>
						<input type="text" id="importeSancionHasta" name="importeSancionHasta" class="form-control rangoFiltro" />
					</div>
					<div class="form-group col-xs-4">
						<div class="row">
							<label for="fechaAcuseAcuerdoIncoacionFiltro" class="fechaFiltro"><spring:message code="busquedaSanciones.fechaAcuseAcuerdoIncoacion" /></label>
						</div>
						<input type="text" id="fechaAcuseAcuerdoIncoacionDesde" name="fechaAcuseAcuerdoIncoacionDesde" class="form-control campoFecha" /><span><spring:message code="busquedaSanciones.hasta" /></span>
						<input type="text" id="fechaAcuseAcuerdoIncoacionHasta" name="fechaAcuseAcuerdoIncoacionHasta" class="form-control campoFecha" />
					</div>
					<div class="form-group col-xs-4">
						<div class="row">
							<label for="fechaSancionFirmeFiltro" class="fechaFiltro"><spring:message code="busquedaSanciones.fechaSancionFirme" /></label>
						</div>
						<input type="text" id="fechaSancionFirmeDesde" name="fechaSancionFirmeDesde" class="form-control campoFecha" /><span><spring:message code="busquedaSanciones.hasta" /></span>
						<input type="text" id="fechaSancionFirmeHasta" name="fechaSancionFirmeHasta" class="form-control campoFecha" />
					</div>
				</div>
				
				<div class="row">
					<div class="col-xs-4 form-group">
						<label for="idDireccion"><spring:message code="busquedaSanciones.direccion"/></label>
						<select name="expediente.procedimiento.direcciones.idDireccion" id="idDireccion" class="form-control"></select>
					</div>
					<div class="col-xs-4 form-group">
						<label for="idTipoFinalizacion"><spring:message code="busquedaSanciones.tipoFinalizacion"/></label>
						<select name="tipoFinalizacion.idTipoFinalizacion" id="idTipoFinalizacion" class="form-control"></select>
					</div>
				</div>
				<div class="row mt-4">
					<div class="col-xs-5 form-group checkbox">
						<div class="movcheckbox">
							<input type="checkbox" id="expedientesSinPropuesta" /><label for="expedientesSinPropuesta"><spring:message code="busquedaSanciones.expedientesSinPropuesta"/></label>
						</div>
					</div>
					<div class="col-xs-4 form-group checkbox">
						<div class="movcheckbox">
							<input type="checkbox" id="expedientesCerrados" /><label for="expedientesCerrados"><spring:message code="busquedaSanciones.expedientesCerrados"/></label>
						</div>
					</div>	
				</div>
			</form>
		</div>
	</div>
	
	
	
	
		
		<div id="tablaBusquedaSanciones" class="card-body">
			<div id="sanciones_feedback"></div>
			
			<jsp:include page="includes/busquedaSancionesFilterForm.jsp"></jsp:include>

			<div class="botoneraTabla">
				<button class="btn btn-default btn-circle" id="btnVerSancion" type="button" data-toggle="tooltip" data-placement="top" title='<spring:message code="tooltip.verSancion"/>'><i class="fa fa-pencil-square-o"></i></button>				
				<button class="btn btn-default btn-circle" id="btnExportarExcel" type="button" data-toggle="tooltip" data-placement="top" title='<spring:message code="tooltip.exportarExcel"/>'><i class="fa fa-file-excel-o"></i></button>
			</div>
			<table id="sanciones" class="table table-striped" data-url-base="/ab59WebAppWar/sanciones" data-filter-form="#sanciones_filter_form" style="width: 100%;">
		        <thead>
		            <tr>	
		                <th data-col-prop="idSancion" ></th> <!--  0 -->
		                <th data-col-prop="expediente.folderNumber" data-col-sidx="FOLDERNUMBER"><spring:message code="busquedaSanciones.numExpediente"/></th> <!--  1 -->
		                <th data-col-prop="expediente.titulo" data-col-sidx="TITULO"><spring:message code="busquedaSanciones.tituloExpediente"/></th> <!--  2 -->
		                <th data-col-prop="importeSancion" data-col-sidx="IMPORTESANCION"><spring:message code="busquedaSanciones.importeSancion"/></th> <!--  3 -->		                
		                <th data-col-prop="fechaSancionFirme" data-col-sidx="FECHASANCIONFIRME"><spring:message code="busquedaSanciones.fechaSancionFirme"/></th> <!--  4 -->
		            </tr>
		        </thead>
			</table>			
		</div>
	</div>
	<div id="space"></div>
</section>  