package com.ejie.ab59.webservice.adaptadores;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.BusquedasWS;
import com.ejie.ab59.clientesWS.ab61WebService.DatosInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosLlamadaConsultaDatosInteresado;
import com.ejie.ab59.clientesWS.ab61WebService.DatosLlamadaGenerarExpedienteInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosRespuestaConsultaDatosInteresado;
import com.ejie.ab59.clientesWS.ab61WebService.DocumentoAportado;
import com.ejie.ab59.clientesWS.ab61WebService.DocumentoWS;
import com.ejie.ab59.clientesWS.ab61WebService.Exception_Exception;
import com.ejie.ab59.clientesWS.ab61WebService.InicioOficioSancionesWS;
import com.ejie.ab59.clientesWS.ab61WebService.Origen;
import com.ejie.ab59.clientesWS.ab61WebService.PifException_Exception;
import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.webservice.ab61WebServiceService;

/**
 * ab61WebServiceAdaptadorImpl  
 * 
 *  
 */

@Service(value = "ab61WebServiceAdaptadorImpl")
public class ab61WebServiceAdaptadorImpl implements ab61WebServiceAdaptador {

	public static final Logger logger = LoggerFactory.getLogger(ab61WebServiceAdaptadorImpl.class);

	@Autowired()
	private ab61WebServiceService ab61WebServiceService;

	@Override
	public String aportarDocumentoPlatea(Integer idPlantilla, String procedureId, String folderId, Usuario usuario)
			throws Ab61Exception {
		ab61WebServiceAdaptadorImpl.logger.info("ab61WebServiceAdaptadorImpl.aportarDocumentoPlatea - Inicio");
		String respuesta = this.ab61WebServiceService.aportarDocumentoPlatea(idPlantilla, procedureId, folderId,
				usuario);

		ab61WebServiceAdaptadorImpl.logger
				.info("ab61WebServiceAdaptadorImpl.aportarDocumentoPlatea - Return: " + respuesta);
		return respuesta;
	}

	@Override
	public List<DocumentoAportado> aportarDocumentosPlatea(List<DocumentoWS> documentosWS, String folderId,
			String procedureId, Usuario usuario) throws Ab61Exception {
		ab61WebServiceAdaptadorImpl.logger.info("ab61WebServiceAdaptadorImpl.aportarDocumentosPlatea - Inicio");
		List<DocumentoAportado> respuesta = this.ab61WebServiceService.aportarDocumentosPlatea(documentosWS, folderId,
				procedureId, usuario);

		ab61WebServiceAdaptadorImpl.logger
				.info("ab61WebServiceAdaptadorImpl.aportarDocumentosPlatea - Return: " + respuesta);
		return respuesta;
	}

	@Override
	public String descargarDocumentoDokusi(String oidDokusi, String aplicacion, Integer tipoUrl)
			throws Ab61Exception, PifException_Exception {
		ab61WebServiceAdaptadorImpl.logger.info("ab61WebServiceAdaptadorImpl.descargarDocumentoDokusi - Inicio");
		String respuesta = this.ab61WebServiceService.descargarDocumentoDokusi(oidDokusi, aplicacion, tipoUrl);

		ab61WebServiceAdaptadorImpl.logger
				.info("ab61WebServiceAdaptadorImpl.descargarDocumentoDokusi - Return: " + respuesta);
		return respuesta;
	}

	@Override
	public String descargarDocumentoPid(String oidPID, String aplicacion, Integer tipoUrl)
			throws Ab61Exception, PifException_Exception {
		ab61WebServiceAdaptadorImpl.logger.info("ab61WebServiceAdaptadorImpl.descargarDocumentoPid - Inicio");
		String respuesta = this.ab61WebServiceService.descargarDocumentoPid(oidPID, aplicacion, tipoUrl);

		ab61WebServiceAdaptadorImpl.logger
				.info("ab61WebServiceAdaptadorImpl.descargarDocumentoPid - Return: " + respuesta);
		return respuesta;
	}

	@Override
	public String descargarDocumentoNegocio(Integer idPlantilla, String identificador, Origen origen, String codAplic,
			Boolean descargaraFormatoPdf) throws Ab61Exception {
		ab61WebServiceAdaptadorImpl.logger.info("ab61WebServiceAdaptadorImpl.descargarDocumentoNegocio - Inicio");
		return this.ab61WebServiceService.descargarDocumentoNegocio(idPlantilla, identificador, origen, codAplic,
				descargaraFormatoPdf);
	}

	@Override
	public String generarDocumentoNegocio(Integer idPlantilla, String identificador, Origen origen, String usuario)
			throws Ab61Exception {
		ab61WebServiceAdaptadorImpl.logger.info("ab61WebServiceAdaptadorImpl.generarDocumentoNegocio - Inicio");
		return this.ab61WebServiceService.generarDocumentoNegocio(idPlantilla, identificador, origen, usuario);
	}

	@Override
	public String modificarDocumentoNegocio(Integer idPlantilla, String identificador, String usuario)
			throws Ab61Exception {
		ab61WebServiceAdaptadorImpl.logger.info("ab61WebServiceAdaptadorImpl.modificarDocumentoNegocio - Inicio");
		String respuesta = this.ab61WebServiceService.modificarDocumentoNegocio(idPlantilla, identificador, usuario);

		ab61WebServiceAdaptadorImpl.logger
				.info("ab61WebServiceAdaptadorImpl.modificarDocumentoNegocio - Return: " + respuesta);
		return respuesta;
	}

	public String eliminarDocumentoNegocio(Integer idPlantilla, String identificador) throws Ab61Exception {
		ab61WebServiceAdaptadorImpl.logger.info("ab61WebServiceAdaptadorImpl.eliminarDocumentoNegocio - Inicio");
		String respuesta = this.ab61WebServiceService.eliminarDocumentoNegocio(idPlantilla, identificador);

		ab61WebServiceAdaptadorImpl.logger
				.info("ab61WebServiceAdaptadorImpl.eliminarDocumentoNegocio - Return: " + respuesta);
		return respuesta;
	}

	public String generarExcelListados(Integer idListado, List<BusquedasWS> listaBusquedas, String codAplic,
			Integer idProcedimiento) throws Ab61Exception {
		ab61WebServiceAdaptadorImpl.logger.info("ab61WebServiceAdaptadorImpl.generarExcelListados - Inicio");
		String respuesta = this.ab61WebServiceService.generarExcelListados(idListado, listaBusquedas, codAplic,
				idProcedimiento);

		ab61WebServiceAdaptadorImpl.logger
				.info("ab61WebServiceAdaptadorImpl.generarExcelListados - Return: " + respuesta);
		return respuesta;
	}

	public boolean actualizarParticipaciones(String folderId, String usuario) throws Exception_Exception {
		ab61WebServiceAdaptadorImpl.logger.info("ab61WebServiceAdaptadorImpl.actualizarParticipaciones - Inicio");
		boolean respuesta = this.ab61WebServiceService.actualizarParticipaciones(folderId, usuario);

		ab61WebServiceAdaptadorImpl.logger
				.info("ab61WebServiceAdaptadorImpl.actualizarParticipaciones - Return: " + respuesta);
		return respuesta;
	}

	/**
	 * Metodo que obtendra los datos del tercero asi como los de su
	 * representante si lo tuviera.
	 * 
	 * La idea del metodo es utilizarla previo a la generacion del expediente de
	 * inicio oficio y asi el usuario poder consultar/ver la informacion con la
	 * que se completara el expediente de inicio oficio.
	 */
	@Override
	public List<DatosRespuestaConsultaDatosInteresado> obtenerDatosInteresado(
			DatosLlamadaConsultaDatosInteresado datosRecibidos) throws Ab61Exception {
		ab61WebServiceAdaptadorImpl.logger.info("ab61WebServiceAdaptadorImpl.obtenerDatosInteresado - Inicio");
		List<DatosRespuestaConsultaDatosInteresado> respuesta = this.ab61WebServiceService
				.obtenerDatosInteresado(datosRecibidos);

		ab61WebServiceAdaptadorImpl.logger
				.info("ab61WebServiceAdaptadorImpl.obtenerDatosInteresado - Return: " + respuesta);
		return respuesta;
	}

	@Override
	public DatosInicioOficio generarExpedienteInicioOficioConDatosInteresado(
			DatosLlamadaGenerarExpedienteInicioOficio datosLlamada) throws Ab61Exception {
		ab61WebServiceAdaptadorImpl.logger
				.info("ab61WebServiceAdaptadorImpl.generarExpedienteInicioOficioConDatosInteresado - Inicio");
		DatosInicioOficio respuesta = this.ab61WebServiceService
				.generarExpedienteInicioOficioConDatosInteresado(datosLlamada);

		ab61WebServiceAdaptadorImpl.logger.info(
				"ab61WebServiceAdaptadorImpl.generarExpedienteInicioOficioConDatosInteresado - Return: " + respuesta);
		return respuesta;
	}
}
