package com.ejie.ab59.webservice.adaptadores;

import java.io.BufferedInputStream;
import java.io.InputStream;

import com.ejie.ab59.exceptions.PifException;

/**
 * 
 *  
 *
 */

public interface PifAdapter {

	/**
	 * Obtener documento a PIF
	 * 
	 * @param file
	 *            Fichero que se va a subir al PIF
	 * @param fileName
	 *            Nombre del fichero
	 * @return
	 * @throws NumberFormatException
	 * @throws P28bPifException
	 */
	BufferedInputStream getFile(String pathFrom) throws NumberFormatException, PifException;

	/**
	 * Subir documento a PIF
	 *
	 * @param file
	 *            Fichero que se va a subir al PIF para posteriormente subir a
	 *            PID
	 * @param fileName
	 *            Nombre del fichero
	 * @return String
	 * @throws PifException
	 */
	public String putFileToPID(InputStream file, String fileName) throws PifException;
}
