package com.ejie.ab59.webservice;

import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.Ab61ExceptionGeneral;
import com.ejie.ab59.clientesWS.ab61WebService.Ab61WebService;
import com.ejie.ab59.clientesWS.ab61WebService.BusquedasWS;
import com.ejie.ab59.clientesWS.ab61WebService.DatosInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosLlamadaConsultaDatosInteresado;
import com.ejie.ab59.clientesWS.ab61WebService.DatosLlamadaGenerarExpedienteInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosRespuestaConsultaDatosInteresado;
import com.ejie.ab59.clientesWS.ab61WebService.DocumentoAportado;
import com.ejie.ab59.clientesWS.ab61WebService.DocumentoWS;
import com.ejie.ab59.clientesWS.ab61WebService.Exception_Exception;
import com.ejie.ab59.clientesWS.ab61WebService.InicioOficioSancionesWS;
import com.ejie.ab59.clientesWS.ab61WebService.Origen;
import com.ejie.ab59.clientesWS.ab61WebService.PifException_Exception;
import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.clientesWS.ab61WebService.WebServiceImpl;
import com.ejie.ab59.comun.UtilsConfig;

/**
 * 
 *  
 *
 */

@Service(value = "ab61WebServiceServiceImpl")
public class ab61WebServiceServiceImpl implements ab61WebServiceService {

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	public static final Logger logger = LoggerFactory.getLogger(ab61WebServiceServiceImpl.class);

	private Ab61WebService service;

	private WebServiceImpl getab61WebServiceServiceImplServicePort() {
		return this.getab61WebServiceServiceImplServicePort(true);
	}

	/**
	 * 
	 * @param getPort
	 *            boolean
	 * 
	 * @return proxy WebServiceImpl
	 */
	private WebServiceImpl getab61WebServiceServiceImplServicePort(boolean getPort) {
		try {

			if (this.service == null) {

				// Creamos el servicio
				logger.info("getab61WebServiceServiceImplServicePort - Crear llamada al Servicio Web:");
				logger.info("Ab61WebService_URL:" + UtilsConfig.getAppProperties().getProperty("Ab61WebService_URL"));
				logger.info(
						"Ab61WebService_QNAME:" + UtilsConfig.getAppProperties().getProperty("Ab61WebService_QNAME"));
				logger.info("Ab61WebService_WS:" + UtilsConfig.getAppProperties().getProperty("Ab61WebService_WS"));

				service = new Ab61WebService(new URL(UtilsConfig.getAppProperties().getProperty("Ab61WebService_URL")),
						new QName(UtilsConfig.getAppProperties().getProperty("Ab61WebService_QNAME"),
								UtilsConfig.getAppProperties().getProperty("Ab61WebService_WS")));

				logger.info(
						"getab61WebServiceServiceImplServicePort - Creacin de la llamada al Servicio Web finalizada");
			}
			if (getPort) {

				logger.info("getab61WebServiceServiceImplServicePort - Antes de obtener el proxy");

				WebServiceImpl proxy = this.service.getAb61WebServicePort();

				logger.info("getab61WebServiceServiceImplServicePort - Proxy obtenido");

				Map<String, Object> ctxt = ((BindingProvider) proxy).getRequestContext();

				logger.info("getab61WebServiceServiceImplServicePort - Contexto obtenido");

				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						UtilsConfig.getAppProperties().getProperty("Ab61WebService_URL"));

				logger.info("getab61WebServiceServiceImplServicePort - Contexto cargado");

				return proxy;
			}
		} catch (Exception e) {

			logger.error("getab61WebServiceServiceImplServicePort. Excepcion:" + e.getMessage());
			this.service = null;
		}
		return null;
	}

	@Override
	public String aportarDocumentoPlatea(Integer idPlantilla, String procedureId, String folderId, Usuario usuario)
			throws Ab61Exception {
		try {
			return getab61WebServiceServiceImplServicePort().aportarDocumentoPlatea(idPlantilla, procedureId, folderId,
					usuario);
		} catch (NullPointerException null_pointer_exception) {

			logger.error("getab61WebServiceServiceImplServicePort.aportarDocumentoPlatea", null_pointer_exception);

			String sCodigoError = "error.conectarAB61";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(null_pointer_exception.getMessage(), ab61ExceptionGeneral);

		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.aportarDocumentoPlatea", exception);

			String sCodigoError = "error.conectarTramitagune";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(exception.getMessage(), ab61ExceptionGeneral);

		} finally {
			logger.info("getab61WebServiceServiceImplServicePort.aportarDocumentoPlatea - Final");
		}
	}

	@Override
	public List<DocumentoAportado> aportarDocumentosPlatea(List<DocumentoWS> documentosWS, String folderId,
			String procedureId, Usuario usuario) throws Ab61Exception {
		try {
			return getab61WebServiceServiceImplServicePort().aportarDocumentosPlatea(documentosWS, folderId,
					procedureId, usuario);
		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.aportarDocumentosPlatea", exception);

			String sCodigoError = "error.conectarAB61";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(exception.getMessage(), ab61ExceptionGeneral);

		} finally {
			logger.info("getab61WebServiceServiceImplServicePort.aportarDocumentosPlatea - Final");
		}
	}

	@Override
	public String descargarDocumentoDokusi(String oidDokusi, String aplicacion, Integer tipoUrl)
			throws Ab61Exception, PifException_Exception {
		try {
			return getab61WebServiceServiceImplServicePort().descargarDocumentoDokusi(oidDokusi, aplicacion, tipoUrl);
		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.descargarDocumentoDokusi", exception);

			String sCodigoError = "error.conectarAB61";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(exception.getMessage(), ab61ExceptionGeneral);

		} finally {
			logger.info("getab61WebServiceServiceImplServicePort.descargarDocumentoDokusi - Final");
		}
	}

	@Override
	public String descargarDocumentoPid(String oidPID, String aplicacion, Integer tipoUrl)
			throws Ab61Exception, PifException_Exception {
		try {
			return getab61WebServiceServiceImplServicePort().descargarDocumentoPid(oidPID, aplicacion, tipoUrl);
		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.descargarDocumentoPid", exception);

			String sCodigoError = "error.conectarAB61";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(exception.getMessage(), ab61ExceptionGeneral);
		} finally {
			logger.info("getab61WebServiceServiceImplServicePort.descargarDocumentoPid - Final");
		}
	}

	@Override
	public String descargarDocumentoNegocio(Integer idPlantilla, String identificador, Origen origen, String codAplic,
			Boolean descargaraFormatoPdf) throws Ab61Exception {
		try {
			return getab61WebServiceServiceImplServicePort().descargarDocumentoNegocio(idPlantilla, identificador,
					origen, codAplic, descargaraFormatoPdf);
		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.descargarDocumentoNegocio", exception);

			String sCodigoError = "error.conectarAB61";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(exception.getMessage(), ab61ExceptionGeneral);
		} finally {
			logger.info("getab61WebServiceServiceImplServicePort.descargarDocumentoNegocio - Final");
		}

	}

	@Override
	public String generarDocumentoNegocio(Integer idPlantilla, String identificador, Origen origen, String usuario)
			throws Ab61Exception {
		try {
			return getab61WebServiceServiceImplServicePort().generarDocumentoNegocio(idPlantilla, identificador, origen,
					usuario);
		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.generarDocumentoNegocio", exception);

			String sCodigoError = "error.conectarAB61";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(exception.getMessage(), ab61ExceptionGeneral);

		} finally {
			logger.info("getab61WebServiceServiceImplServicePort.generarDocumentoNegocio - Final");
		}

	}

	@Override
	public String modificarDocumentoNegocio(Integer idPlantilla, String identificador, String usuario)
			throws Ab61Exception {
		try {
			return getab61WebServiceServiceImplServicePort().modificarDocumentoNegocio(idPlantilla, identificador,
					usuario);
		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.eliminarDocumentoNegocio", exception);

			String sCodigoError = "error.conectarAB61";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(exception.getMessage(), ab61ExceptionGeneral);

		} finally {
			logger.info("getab61WebServiceServiceImplServicePort.modificarDocumentoNegocio - Final");
		}
	}

	@Override
	public String eliminarDocumentoNegocio(Integer idPlantilla, String identificador) throws Ab61Exception {
		try {
			return getab61WebServiceServiceImplServicePort().eliminarDocumentoNegocio(idPlantilla, identificador);
		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.descargarDocumentoNegocio", exception);

			String sCodigoError = "error.conectarAB61";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(exception.getMessage(), ab61ExceptionGeneral);

		} finally {
			logger.info("getab61WebServiceServiceImplServicePort.eliminarDocumentoNegocio - Final");
		}

	}

	@Override
	public String generarExcelListados(Integer idListado, List<BusquedasWS> listaBusquedas, String codAplic,
			Integer idProcedimiento) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().generarExcelListados(idListado, listaBusquedas, codAplic,
				idProcedimiento);
	}

	@Override
	public boolean actualizarParticipaciones(String folderId, String usuario) throws Exception_Exception {
		try {
			return getab61WebServiceServiceImplServicePort().actualizarParticipaciones(folderId, usuario);
		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.actualizarParticipaciones", exception);

			com.ejie.ab59.clientesWS.ab61WebService.Exception ab61ExceptionGeneral = new com.ejie.ab59.clientesWS.ab61WebService.Exception();
			ab61ExceptionGeneral.setMessage(exception.getMessage());

			throw new Exception_Exception(exception.getMessage(), ab61ExceptionGeneral);

		} finally {
			logger.info("getab61WebServiceServiceImplServicePort.actualizarParticipaciones - Final");
		}
	}

	@Override
	public DatosInicioOficio generarInicioOficioSanciones(InicioOficioSancionesWS inicioOficioSancionesWS)
			throws Ab61Exception {
		try {
			return getab61WebServiceServiceImplServicePort().generarInicioOficioSanciones(inicioOficioSancionesWS);
		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.generarInicioOficioSanciones", exception);

			String sCodigoError = "error.conectarAB61";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(exception.getMessage(), ab61ExceptionGeneral);

		} finally {
			logger.info("getab61WebServiceServiceImplServicePort.generarInicioOficioSanciones - Final");
		}
	}

	/**
	 * Metodo que obtendra los datos del tercero asi como los de su
	 * representante si lo tuviera.
	 * 
	 * La idea del metodo es utilizarla previo a la generacion del expediente de
	 * inicio oficio y asi el usuario poder consultar/ver la informacion con la
	 * que se completara el expediente de inicio oficio.
	 */
	@Override
	public List<DatosRespuestaConsultaDatosInteresado> obtenerDatosInteresado(
			DatosLlamadaConsultaDatosInteresado datosRecibidos) throws Ab61Exception {
		try {
			return getab61WebServiceServiceImplServicePort().obtenerDatosInteresado(datosRecibidos);
		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.obtenerDatosInteresado", exception);

			String sCodigoError = "error.conectarAB61";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(exception.getMessage(), ab61ExceptionGeneral);

		} finally {
			logger.info("getab61WebServiceServiceImplServicePort.obtenerDatosInteresado - Final");
		}
	}

	@Override
	public DatosInicioOficio generarExpedienteInicioOficioConDatosInteresado(
			DatosLlamadaGenerarExpedienteInicioOficio datosLlamada) throws Ab61Exception {
		try {
			return getab61WebServiceServiceImplServicePort()
					.generarExpedienteInicioOficioConDatosInteresado(datosLlamada);
		} catch (Exception exception) {

			logger.error("getab61WebServiceServiceImplServicePort.generarExpedienteInicioOficioConDatosInteresado",
					exception);

			String sCodigoError = "error.conectarAB61";

			Ab61ExceptionGeneral ab61ExceptionGeneral = new Ab61ExceptionGeneral();
			ab61ExceptionGeneral.setCodigo(sCodigoError);
			ab61ExceptionGeneral
					.setMensajeCastellano(appMessageSource.getMessage(sCodigoError, null, new Locale("es")));
			ab61ExceptionGeneral.setMensajeEuskera(appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			throw new Ab61Exception(exception.getMessage(), ab61ExceptionGeneral);

		} finally {
			logger.info(
					"getab61WebServiceServiceImplServicePort.generarExpedienteInicioOficioConDatosInteresado - Final");
		}
	}
}
