package com.ejie.ab59.webservice;

import java.util.List;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.BusquedasWS;
import com.ejie.ab59.clientesWS.ab61WebService.DatosInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosLlamadaConsultaDatosInteresado;
import com.ejie.ab59.clientesWS.ab61WebService.DatosLlamadaGenerarExpedienteInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosRespuestaConsultaDatosInteresado;
import com.ejie.ab59.clientesWS.ab61WebService.DocumentoAportado;
import com.ejie.ab59.clientesWS.ab61WebService.DocumentoWS;
import com.ejie.ab59.clientesWS.ab61WebService.Exception_Exception;
import com.ejie.ab59.clientesWS.ab61WebService.InicioOficioSancionesWS;
import com.ejie.ab59.clientesWS.ab61WebService.Origen;
import com.ejie.ab59.clientesWS.ab61WebService.PifException_Exception;
import com.ejie.ab59.clientesWS.ab61WebService.Usuario;

/**
 * 
 *  
 *
 */

public interface ab61WebServiceService {

	String aportarDocumentoPlatea(Integer idPlantilla, String procedureId, String folderId, Usuario usuario)
			throws Ab61Exception;

	List<DocumentoAportado> aportarDocumentosPlatea(List<DocumentoWS> documentosWS, String folderId, String procedureId,
			Usuario usuario) throws Ab61Exception;

	public String descargarDocumentoDokusi(String oidDokusi, String aplicacion, Integer tipoUrl)
			throws Ab61Exception, PifException_Exception;

	public String descargarDocumentoPid(String oidPID, String aplicacion, Integer tipoUrl)
			throws Ab61Exception, PifException_Exception;

	String descargarDocumentoNegocio(Integer idPlantilla, String identificador, Origen origen, String codAplic,
			Boolean descargaraFormatoPdf) throws Ab61Exception;

	String generarDocumentoNegocio(Integer idPlantilla, String identificado, Origen origen, String usuario)
			throws Ab61Exception;

	String modificarDocumentoNegocio(Integer idPlantilla, String identificador, String usuario) throws Ab61Exception;

	String eliminarDocumentoNegocio(Integer idPlantilla, String identificador) throws Ab61Exception;

	String generarExcelListados(Integer idListado, List<BusquedasWS> listaBusquedas, String codAplic,
			Integer idProcedimiento) throws Ab61Exception;

	public boolean actualizarParticipaciones(String folderId, String usuario) throws Exception_Exception;

	DatosInicioOficio generarInicioOficioSanciones(InicioOficioSancionesWS inicioOficioSancionesWS)
			throws Ab61Exception;

	/**
	 * Metodo que obtendra los datos del tercero asi como los de su
	 * representante si lo tuviera.
	 * 
	 * La idea del metodo es utilizarla previo a la generacion del expediente de
	 * inicio oficio y asi el usuario poder consultar/ver la informacion con la
	 * que se completara el expediente de inicio oficio.
	 */
	List<DatosRespuestaConsultaDatosInteresado> obtenerDatosInteresado(
			DatosLlamadaConsultaDatosInteresado datosRecibidos) throws Ab61Exception;

	DatosInicioOficio generarExpedienteInicioOficioConDatosInteresado(
			DatosLlamadaGenerarExpedienteInicioOficio datosLlamada) throws Ab61Exception;
}
