package com.ejie.ab59.webservice;

import java.io.BufferedInputStream;
import java.io.InputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;

import com.ejie.ab59.exceptions.PifException;
import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;

/**
 * 
 *  
 *
 */

@Service(value = "PifServiceImpl")
public class PifServiceImpl implements PifService {

	private static final Logger logger = LoggerFactory.getLogger(PifServiceImpl.class);

	/**
	 * Clase que hara de facade para invocar los servicios de PIF
	 */
	private PifServiceImpl() {
		super();
	}

	/**
	 * putFile
	 *
	 * @param sSessionToken
	 *            Sesion de aplicacion que esta escribiendo en el repositorio
	 * @param file
	 *            Stream de datos para acceder al contenido a copiar en el
	 *            repositorio
	 * @param pathTo
	 *            Ruta logica donde alojar el fichero. Incluir como carpeta
	 *            principal la aplicacion destino (/ab64a/...)
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de digitos que lo hace unico en el repositorio
	 * @param Ttl
	 *            Numero de segundos que se desea mantener el fichero en el
	 *            repositorio. Como maximo se podra fijar el numero de segundos
	 *            de 15 dias naturales
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws PifException
	 */
	@Override()
	public Y31AttachmentBean putFile(Document sSessionToken, InputStream file, String pathTo, boolean preserveName,
			Long Ttl) throws PifException {
		try {
			Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
			return service.put(sSessionToken, file, pathTo, preserveName, Ttl);
		} catch (Y31JanoServiceGenericException e) {
			throw new PifException(e.getMessage());
		} catch (Y31JanoServiceFileNameFormatException e) {
			throw new PifException(e.getMessage());
		} catch (Y31JanoServiceMongoDbGenericException e) {
			throw new PifException(e.getMessage());
		} catch (Y31JanoServiceEventJmsException e) {
			throw new PifException(e.getMessage());
		} catch (Y31JanoServiceAccesDeniedException e) {
			throw new PifException(e.getMessage());
		}
	}

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica de donde se va a descargar el fichero.
	 *            Incluir� como carpeta principal la aplicaci�n destino
	 * @return InputStream
	 * @throws PifException
	 */
	public BufferedInputStream getFile(Document sSessionToken, String pathFrom) throws PifException {
		// obteniendo un objeto service
		Y31JanoService service;
		try {
			service = Y31JanoServiceAbstractFactory.getInstance();

			// invocando el metodo
			return new BufferedInputStream(service.get(sSessionToken, pathFrom));
		} catch (Y31JanoServiceGenericException e) {
			logger.error("getFile:Y31JanoServiceGenericException: " + e);
			throw new PifException(e.getMessage(), e.getCause());
		} catch (Y31JanoServiceFileNotFoundException e) {
			logger.error("getFile:Y31JanoServiceFileNotFoundException: " + e);
			throw new PifException(e.getMessage(), e.getCause());
		} catch (Y31JanoServiceFileNameFormatException e) {
			logger.error("getFile:Y31JanoServiceFileNameFormatException: " + e);
			throw new PifException(e.getMessage(), e.getCause());
		} catch (Y31JanoServiceMongoDbGenericException e) {
			logger.error("getFile:Y31JanoServiceMongoDbGenericException: " + e);
			throw new PifException(e.getMessage(), e.getCause());
		} catch (Y31JanoServiceOracleGenericException e) {
			logger.error("getFile:Y31JanoServiceOracleGenericException: " + e);
			throw new PifException(e.getMessage(), e.getCause());
		} catch (Y31JanoServiceAccesDeniedException e) {
			logger.error("getFile:Y31JanoServiceAccesDeniedException: " + e);
			throw new PifException(e.getMessage(), e.getCause());
		}

	}

}
