package com.ejie.ab59.webservice;

import java.io.InputStream;

import org.w3c.dom.Document;

import com.ejie.ab59.exceptions.PifException;
import com.ejie.y31.vo.Y31AttachmentBean;

/**
 * 
 *  
 *
 */

public interface PifService {
	/**
	 * putFile
	 *
	 * @param sSessionToken
	 *            Sesion de aplicacion que esta escribiendo en el repositorio
	 * @param file
	 *            Stream de datos para acceder al contenido a copiar en el
	 *            repositorio
	 * @param pathTo
	 *            Ruta logica donde alojar el fichero. Incluir como carpeta
	 *            principal la aplicacion destino (/ab64a/...)
	 * @param preserveName
	 *            Indica si se desea preservar el nombre del fichero en la ruta
	 *            seleccionada sobrescribiendo el fichero si existiera. Si se
	 *            decide no preservar los nombres lo que se hace es concatenarle
	 *            una serie de digitos que lo hace unico en el repositorio
	 * @param Ttl
	 *            Numero de segundos que se desea mantener el fichero en el
	 *            repositorio. Como maximo se podra fijar el numero de segundos
	 *            de 15 dias naturales
	 * @return Y31AttachmentBean Y31AttachmentBean
	 * @throws PifException
	 */
	Y31AttachmentBean putFile(Document sSessionToken, InputStream file, String pathTo, boolean preserveName, Long Ttl)
			throws PifException;

	/**
	 * 
	 * @param sSessionToken
	 *            Sesi�n de aplicaci�n que est� escribiendo en el
	 *            repositorio
	 * @param pathFrom
	 *            Ruta l�gica de donde se va a descargar el fichero.
	 *            Incluir� como carpeta principal la aplicaci�n destino
	 * @return InputStream
	 * @throws PifException
	 *             excepcion en el PIF
	 */
	InputStream getFile(Document sSessionToken, String pathFrom) throws PifException;
}
