package com.ejie.ab59.service.tablasMaestras;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.tablasMaestras.TiposFinalizacionDao;
import com.ejie.ab59.model.tablasMaestras.TiposFinalizacion;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */

@Service(value = "tiposFinalizacionService")
public class TiposFinalizacionServiceImpl implements TiposFinalizacionService {

	@Autowired
	private TiposFinalizacionDao tiposFinalizacionDao;

	/**
	 * Inserts a single row in the TiposFinalizacion table.
	 *
	 * @param tipoFinalizacion
	 *            TiposFinalizacion
	 * @return TiposFinalizacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TiposFinalizacion add(TiposFinalizacion tipoFinalizacion) {
		return this.tiposFinalizacionDao.add(tipoFinalizacion);
	}

	/**
	 * Updates a single row in the TiposFinalizacion table.
	 *
	 * @param tipoFinalizacion
	 *            TiposFinalizacion
	 * @return TiposFinalizacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TiposFinalizacion update(TiposFinalizacion tipoFinalizacion) {
		return this.tiposFinalizacionDao.update(tipoFinalizacion);
	}

	/**
	 * Finds a single row in the TiposFinalizacion table.
	 *
	 * @param tipoFinalizacion
	 *            TiposFinalizacion
	 * @return TiposFinalizacion
	 */
	public TiposFinalizacion find(TiposFinalizacion tipoFinalizacion) {
		return this.tiposFinalizacionDao.find(tipoFinalizacion);
	}

	/**
	 * Finds a list of rows in the TiposFinalizacion table.
	 *
	 * @param tiposFinalizacion
	 *            TiposFinalizacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TiposFinalizacion>
	 */
	public List<TiposFinalizacion> findAll(TiposFinalizacion tiposFinalizacion, TableRequestDto tableRequestDto) {
		return this.tiposFinalizacionDao.findAll(tiposFinalizacion, tableRequestDto);
	}

	/**
	 * Filter method in the TiposFinalizacion table.
	 *
	 * @param filterTiposFinalizacion
	 *            TiposFinalizacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<TiposFinalizacion>
	 */
	public TableResponseDto<TiposFinalizacion> filter(TiposFinalizacion filterTiposFinalizacion,
			TableRequestDto tableRequestDto) {
		List<TiposFinalizacion> listaTiposFinalizacion = this.tiposFinalizacionDao.findAll(filterTiposFinalizacion,
				tableRequestDto);
		Long recordNum = this.tiposFinalizacionDao
				.findAllCount(filterTiposFinalizacion != null ? filterTiposFinalizacion : new TiposFinalizacion());

		return new TableResponseDto<TiposFinalizacion>(tableRequestDto, recordNum, listaTiposFinalizacion);
	}

	/**
	 * Finds a list of rows in the TiposFinalizacion table.
	 *
	 * @param tiposFinalizacion
	 *            TiposFinalizacion
	 * 
	 * @return List<TiposFinalizacion>
	 */
	public List<TiposFinalizacion> cargarCombo(TiposFinalizacion tiposFinalizacion) {
		return this.tiposFinalizacionDao.cargarCombo(tiposFinalizacion);
	}

	@Override
	public void remove(TiposFinalizacion tipoFinalizacion) {
		this.tiposFinalizacionDao.remove(tipoFinalizacion);
	}

}
