package com.ejie.ab59.service.tablasMaestras;

import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.tablasMaestras.RelInfDerDao;
import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.ab59.model.tablasMaestras.RelInfDer;

/**
 * RelInfDerServiceImpl  
 * 
 *  
 */

@Service(value = "relInfDerService")
public class RelInfDerServiceImpl implements RelInfDerService {

	@Autowired
	private RelInfDerDao relInfDerDao;

	/**
	 * Inserts a single row in the RelInfDer table.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 * @return RelInfDer
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RelInfDer add(RelInfDer relInfDer) {
		return this.relInfDerDao.add(relInfDer);
	}

	/**
	 * Updates a single row in the RelInfDer table.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 * @return RelInfDer
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RelInfDer update(RelInfDer relInfDer) {
		return this.relInfDerDao.update(relInfDer);
	}

	/**
	 * Finds a single row in the RelInfDer table.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 * @return RelInfDer
	 */
	public RelInfDer find(RelInfDer relInfDer) {
		return (RelInfDer) this.relInfDerDao.find(relInfDer);
	}

	/**
	 * Deletes a single row in the RelInfDer table.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RelInfDer relInfDer) {
		this.relInfDerDao.remove(relInfDer);
	}

	@Override
	public void removeByIdDerecho(Derechos derechos) {
		this.relInfDerDao.removeByIdDerecho(derechos);
	}

	/**
	 * Finds a list of rows in the RelInfDer table.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelInfDer>
	 */
	public List<RelInfDer> findAll(RelInfDer relInfDer, TableRequestDto tableRequestDto) {
		return (List<RelInfDer>) this.relInfDerDao.findAll(relInfDer, tableRequestDto);
	}

	/**
	 * Finds rows in the RelInfDer table using like.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<RelInfDer>
	 */
	public List<RelInfDer> findAllLike(RelInfDer relInfDer, TableRequestDto tableRequestDto, Boolean startsWith) {
		return (List<RelInfDer>) this.relInfDerDao.findAllLike(relInfDer, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto, Boolean startsWith) {
		this.relInfDerDao.removeMultiple(filterRelInfDer, tableRequestDto, startsWith);
	}

	/**
	 * Filter method in the RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<RelInfDer>
	 */
	public TableResponseDto<RelInfDer> filter(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		List<RelInfDer> listaRelInfDer = this.relInfDerDao.findAllLike(filterRelInfDer, tableRequestDto, false);
		Long recordNum = this.relInfDerDao.findAllLikeCount(filterRelInfDer != null ? filterRelInfDer : new RelInfDer(),
				false);

		TableResponseDto<RelInfDer> usuarioDto = new TableResponseDto<RelInfDer>(tableRequestDto, recordNum,
				listaRelInfDer);

		if (tableRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<RelInfDer>> reorderSelection = this.relInfDerDao.reorderSelection(filterRelInfDer,
					tableRequestDto, startsWith);
			usuarioDto.setReorderedSelection(reorderSelection);
			usuarioDto.addAdditionalParam("reorderedSelection", reorderSelection);
			usuarioDto.addAdditionalParam("selectedAll", tableRequestDto.getMultiselection().getSelectedAll());
		}
		if (tableRequestDto.getSeeker().getSelectedIds() != null) {
			tableRequestDto.setMultiselection(tableRequestDto.getSeeker());
			List<TableRowDto<RelInfDer>> reorderSeeker = this.relInfDerDao.reorderSelection(filterRelInfDer,
					tableRequestDto, startsWith);
			usuarioDto.setReorderedSeeker(reorderSeeker);
			usuarioDto.addAdditionalParam("reorderedSeeker", reorderSeeker);
		}
		return usuarioDto;
	}

	/**
	 * Searches rows in the RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param searchRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelInfDer>>
	 */
	public List<TableRowDto<RelInfDer>> search(RelInfDer filterRelInfDer, RelInfDer searchRelInfDer,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.relInfDerDao.search(filterRelInfDer, searchRelInfDer, tableRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.relInfDerDao.reorderSelection(filterRelInfDer, tableRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<RelInfDer>>
	 */
	public TableResponseDto<JerarquiaDto<RelInfDer>> jerarquia(RelInfDer filterRelInfDer,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		List<JerarquiaDto<RelInfDer>> listaRelInfDer = this.relInfDerDao.findAllLikeJerarquia(filterRelInfDer,
				tableRequestDto);
		Long recordNum = this.relInfDerDao.findAllLikeCountJerarquia(filterRelInfDer, tableRequestDto);
		return new TableResponseDto<JerarquiaDto<RelInfDer>>(tableRequestDto, recordNum, listaRelInfDer);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<RelInfDer>>
	 */
	public TableResponseDto<JerarquiaDto<RelInfDer>> jerarquiaChildren(RelInfDer filterRelInfDer,
			TableRequestDto tableRequestDto) {
		TableResponseDto<JerarquiaDto<RelInfDer>> tableResponseDto = new TableResponseDto<JerarquiaDto<RelInfDer>>();
		tableResponseDto.addAdditionalParam(TableResponseDto.CHILDREN,
				this.relInfDerDao.findAllChild(filterRelInfDer, tableRequestDto));
		return tableResponseDto;
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<RelInfDer> getMultiple(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto, Boolean startsWith) {
		return this.relInfDerDao.getMultiple(filterRelInfDer, tableRequestDto, startsWith);
	}

}
