package com.ejie.ab59.service.tablasMaestras;

import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.ab59.model.tablasMaestras.RelInfDer;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;

/**
 * RelInfDerService  
 * 
 *  
 */

public interface RelInfDerService {

	/**
	 * Inserts a single row in the RelInfDer table.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 * @return RelInfDer
	 */
	RelInfDer add(RelInfDer relInfDer);

	/**
	 * Updates a single row in the RelInfDer table.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 * @return RelInfDer
	 */
	RelInfDer update(RelInfDer relInfDer);

	/**
	 * Finds a single row in the RelInfDer table.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 * @return RelInfDer
	 */
	RelInfDer find(RelInfDer relInfDer);

	/**
	 * Deletes a single row in the RelInfDer table.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 */
	void remove(RelInfDer relInfDer);

	/**
	 * Finds a list of rows in the RelInfDer table.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelInfDer>
	 */
	List<RelInfDer> findAll(RelInfDer relInfDer, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the RelInfDer table using like.
	 *
	 * @param relInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<RelInfDer>
	 */
	List<RelInfDer> findAllLike(RelInfDer relInfDer, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Filter method in the RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<RelInfDer>
	 */
	TableResponseDto<RelInfDer> filter(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param searchRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelInfDer>>
	 */
	List<TableRowDto<RelInfDer>> search(RelInfDer filterRelInfDer, RelInfDer searchRelInfDer,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return TableResponseDto<JerarquiaDto<RelInfDer>>
	 */
	TableResponseDto<JerarquiaDto<RelInfDer>> jerarquia(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the RelInfDer table.
	 *
	 * @param filterRelInfDer
	 *            RelInfDer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<JerarquiaDto<RelInfDer>>
	 */
	TableResponseDto<JerarquiaDto<RelInfDer>> jerarquiaChildren(RelInfDer filterRelInfDer,
			TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<RelInfDer> getMultiple(RelInfDer filterRelInfDer, TableRequestDto tableRequestDto, Boolean startsWith);

	void removeByIdDerecho(Derechos derechos);

}
