package com.ejie.ab59.service.tablasMaestras;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.tablasMaestras.InstructoresDao;
import com.ejie.ab59.model.tablasMaestras.Instructores;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */

@Service(value = "instructoresService")
public class InstructoresServiceImpl implements InstructoresService {

	@Autowired
	private InstructoresDao instructoresDao;

	/**
	 * Inserts a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Instructores add(Instructores instructor) {
		return this.instructoresDao.add(instructor);
	}

	/**
	 * Updates a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Instructores update(Instructores instructor) {
		return this.instructoresDao.update(instructor);
	}

	/**
	 * Baja lógica del registro
	 *
	 * @param instructor
	 *            Instructores
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Instructores instructor) {
		this.instructoresDao.remove(instructor);
	}

	/**
	 * Finds a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	public Instructores find(Instructores instructor) {
		return this.instructoresDao.find(instructor);
	}

	/**
	 * Finds a list of rows in the Instructores table.
	 *
	 * @param instructores
	 *            Instructores
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Instructores>
	 */
	public List<Instructores> findAll(Instructores instructores, TableRequestDto tableRequestDto) {
		return this.instructoresDao.findAll(instructores, tableRequestDto);
	}

	/**
	 * Filter method in the Instructores table.
	 *
	 * @param filterInstructores
	 *            Instructores
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<Instructores>
	 */
	public TableResponseDto<Instructores> filter(Instructores filterInstructores, TableRequestDto tableRequestDto) {
		List<Instructores> listaInstructores = this.instructoresDao.findAll(filterInstructores, tableRequestDto);
		Long recordNum = this.instructoresDao
				.findAllCount(filterInstructores != null ? filterInstructores : new Instructores());

		return new TableResponseDto<Instructores>(tableRequestDto, recordNum, listaInstructores);
	}

	/**
	 * Finds a list of rows in the Instructores table.
	 *
	 * @param instructores
	 *            Instructores
	 * 
	 * @return List<Instructores>
	 */
	public List<Instructores> cargarCombo(Instructores instructores) {
		return this.instructoresDao.cargarCombo(instructores);
	}

}
