package com.ejie.ab59.service.tablasMaestras;

import java.util.List;

import com.ejie.ab59.model.tablasMaestras.Instructores;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */

public interface InstructoresService {

	/**
	 * Inserts a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	Instructores add(Instructores instructor);

	/**
	 * Updates a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	Instructores update(Instructores instructor);

	/**
	 * Baja lógica del registro
	 *
	 * @param instructor
	 *            Instructores
	 */
	void remove(Instructores instructor);

	/**
	 * Finds a single row in the Instructores table.
	 *
	 * @param instructor
	 *            Instructores
	 * @return Instructores
	 */
	Instructores find(Instructores instructor);

	/**
	 * Finds a list of rows in the Instructores table.
	 *
	 * @param instructores
	 *            Instructores
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Instructores>
	 */
	List<Instructores> findAll(Instructores instructores, TableRequestDto tableRequestDto);

	/**
	 * Filter method in the Instructores table.
	 *
	 * @param filterInstructores
	 *            Instructores
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<Instructores>
	 */
	TableResponseDto<Instructores> filter(Instructores filterInstructores, TableRequestDto tableRequestDto);

	/**
	 * Finds a list of rows in the Instructores table.
	 *
	 * @param instructores
	 *            Instructores
	 * 
	 * @return List<Instructores>
	 */
	List<Instructores> cargarCombo(Instructores instructores);
}
