package com.ejie.ab59.service.tablasMaestras;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.tablasMaestras.InfraccionesDao;
import com.ejie.ab59.model.propuestasSancion.RelArtInfProSan;
import com.ejie.ab59.model.tablasMaestras.Infracciones;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * InfraccionesServiceImpl  
 * 
 *  
 */

@Service(value = "infraccionesService")
public class InfraccionesServiceImpl implements InfraccionesService {

	@Autowired
	private InfraccionesDao infraccionesDao;

	/**
	 * Finds a list of rows in the Infracciones table.
	 *
	 * @param infracciones
	 *            Infracciones
	 * 
	 * @return List<Infracciones>
	 */
	public List<Infracciones> cargarCombo(Infracciones infracciones) {
		return this.infraccionesDao.cargarCombo(infracciones);
	}

	/**
	 * Filter method in the Infracciones table.
	 *
	 * @param filterInfracciones
	 *            Infracciones
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<Infracciones>
	 */
	public TableResponseDto<Infracciones> filter(Infracciones filterInfracciones, TableRequestDto tableRequestDto) {

		this.fncReordenarSentencia(tableRequestDto);

		List<Infracciones> listaInfracciones = this.infraccionesDao.findAll(filterInfracciones, tableRequestDto);
		Long recordNum = this.infraccionesDao
				.findAllCount(filterInfracciones != null ? filterInfracciones : new Infracciones());

		return new TableResponseDto<Infracciones>(tableRequestDto, recordNum, listaInfracciones);
	}

	/**
	 * Transformar los campos del ORDER BY cuando están dentro de un objeto
	 * 
	 * @param tableRequestDto
	 *            TableRequestDto
	 */
	private void fncReordenarSentencia(TableRequestDto tableRequestDto) {

		if (tableRequestDto != null && tableRequestDto.getSidx() != null) {
			if (tableRequestDto.getSidx().equals("DESCRIPCIONCASTELLANO")) {
				tableRequestDto.setSidx("DESCINFRACCIONCAS");
			} else if (tableRequestDto.getSidx().equals("DESCRIPCIONEUSKERA")) {
				tableRequestDto.setSidx("DESCINFRACCIONEUS");
			}
		}
	}

	/**
	 * Inserts a single row in the Infracciones table.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Infracciones add(Infracciones infraccion) {
		return this.infraccionesDao.add(infraccion);
	}

	/**
	 * Finds a single row in the Infracciones table.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	public Infracciones find(Infracciones infraccion) {
		return this.infraccionesDao.find(infraccion);
	}

	/**
	 * Updates a single row in the Infracciones table.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Infracciones update(Infracciones infraccion) {
		return this.infraccionesDao.update(infraccion);
	}

	/**
	 * Baja lógica del registro
	 *
	 * @param infraccion
	 *            Infracciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Infracciones infraccion) {
		this.infraccionesDao.remove(infraccion);
	}

	/**
	 * Filter method in the RelArtInfProSan table.
	 *
	 * @param filterRelArtInfProSan
	 *            RelArtInfProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<RelArtInfProSan>
	 */
	public TableResponseDto<RelArtInfProSan> filterInfraccionesByPropuestaSancion(RelArtInfProSan filterRelArtInfProSan,
			TableRequestDto tableRequestDto) {

		List<RelArtInfProSan> listaRelArtInfProSan = this.infraccionesDao
				.findInfraccionesByPropuestaSancion(filterRelArtInfProSan, tableRequestDto);
		Long recordNum = this.infraccionesDao.findInfraccionesByPropuestaSancionCount(
				filterRelArtInfProSan != null ? filterRelArtInfProSan : new RelArtInfProSan());

		return new TableResponseDto<RelArtInfProSan>(tableRequestDto, recordNum, listaRelArtInfProSan);
	}

}
