package com.ejie.ab59.service.tablasMaestras;

import java.util.List;

import com.ejie.ab59.model.propuestasSancion.RelArtInfProSan;
import com.ejie.ab59.model.tablasMaestras.Infracciones;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * InfraccionesService  
 * 
 *  
 */

public interface InfraccionesService {

	/**
	 * Finds a list of rows in the Infracciones table.
	 *
	 * @param infracciones
	 *            Infracciones
	 * 
	 * @return List<Infracciones>
	 */
	List<Infracciones> cargarCombo(Infracciones infracciones);

	/**
	 * Filter method in the Infracciones table.
	 *
	 * @param filterInfracciones
	 *            Infracciones
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<Infracciones>
	 */
	TableResponseDto<Infracciones> filter(Infracciones filterInfracciones, TableRequestDto tableRequestDto);

	/**
	 * Inserts a single row in the Infracciones table.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	Infracciones add(Infracciones infraccion);

	/**
	 * Finds a single row in the Infracciones table.
	 *
	 * @param infracciones
	 *            Infracciones
	 * @return Infracciones
	 */
	Infracciones find(Infracciones infracciones);

	/**
	 * Updates a single row in the Infracciones table.
	 *
	 * @param infraccion
	 *            Infracciones
	 * @return Infracciones
	 */
	Infracciones update(Infracciones infraccion);

	/**
	 * Baja lógica del registro
	 *
	 * @param infraccion
	 *            Infracciones
	 */
	void remove(Infracciones infraccion);

	/**
	 * Filter method in the RelArtInfProSan table.
	 *
	 * @param filterRelArtInfProSan
	 *            RelArtInfProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<RelArtInfProSan>
	 */
	TableResponseDto<RelArtInfProSan> filterInfraccionesByPropuestaSancion(RelArtInfProSan filterRelArtInfProSan,
			TableRequestDto tableRequestDto);
}
