package com.ejie.ab59.service.tablasMaestras;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.tablasMaestras.DerechosDao;
import com.ejie.ab59.dao.tablasMaestras.InfraccionesDao;
import com.ejie.ab59.dao.tablasMaestras.RelInfDerDao;
import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.ab59.model.tablasMaestras.Infracciones;
import com.ejie.ab59.model.tablasMaestras.RelInfDer;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */

@Service(value = "derechosService")
public class DerechosServiceImpl implements DerechosService {

	@Autowired
	private DerechosDao derechosDao;

	@Autowired
	private RelInfDerDao relInfDerDao;

	@Autowired
	private InfraccionesDao infraccionesDao;

	/**
	 * Filter method in the Derechos table.
	 *
	 * @param filterDerechos
	 *            Derechos
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<Derechos>
	 */
	public TableResponseDto<Derechos> filter(Derechos filterDerechos, TableRequestDto tableRequestDto) {

		List<Derechos> listaDerechos = this.derechosDao.findAll(filterDerechos, tableRequestDto);

		for (Derechos derecho : listaDerechos) {
			RelInfDer relInfDer = new RelInfDer();
			relInfDer.setIdDerecho(derecho.getIdDerecho());
			List<RelInfDer> listaRelInfDer = this.relInfDerDao.findAll(relInfDer, null);
			String idsInfracciones = "";
			String articulosInfracciones = "";
			String articuloInfraccionEs = "";
			String articuloInfraccionEu = "";
			for (RelInfDer relInfDerAux : listaRelInfDer) {
				idsInfracciones += relInfDerAux.getIdInfraccion().toString() + ",";
			}
			if (idsInfracciones != "") {
				idsInfracciones = idsInfracciones.substring(0, idsInfracciones.length() - 1);
				List<Infracciones> listaInfracciones = this.infraccionesDao.findByIds(idsInfracciones);
				for (Infracciones infraccion : listaInfracciones) {
					articulosInfracciones += infraccion.getArticulo() + "<br/>";
					articuloInfraccionEs += "- " + infraccion.getDescripcionCastellano() + "<br/>";
					articuloInfraccionEu += "- " + infraccion.getDescripcionEuskera() + "<br/>";
				}
			}
			derecho.setIdsInfracciones(idsInfracciones);
			derecho.setArticulosInfracciones(articulosInfracciones);
			derecho.setArticuloInfraccionEs(articuloInfraccionEs);
			derecho.setArticuloInfraccionEu(articuloInfraccionEu);
		}

		Long recordNum = this.derechosDao.findAllCount(filterDerechos != null ? filterDerechos : new Derechos());

		return new TableResponseDto<Derechos>(tableRequestDto, recordNum, listaDerechos);
	}

	/**
	 * Inserts a single row in the Derechos table.
	 *
	 * @param derecho
	 *            Derechos
	 * @return Derechos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Derechos add(Derechos derecho) {
		return this.derechosDao.add(derecho);
	}

	/**
	 * Finds a single row in the Derechos table.
	 *
	 * @param derecho
	 *            Derechos
	 * @return Derechos
	 */
	public Derechos find(Derechos derecho) {
		return this.derechosDao.find(derecho);
	}

	/**
	 * Updates a single row in the Derechos table.
	 *
	 * @param derecho
	 *            Derechos
	 * @return Derechos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Derechos update(Derechos derecho) {
		return this.derechosDao.update(derecho);
	}

	/**
	 * Baja lógica del registro
	 *
	 * @param derecho
	 *            Derechos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Derechos derecho) {
		this.derechosDao.remove(derecho);
	}

	/**
	 * Finds a list of rows in the Derechos table.
	 *
	 * @param derechos
	 *            Derechos
	 * 
	 * @return List<Derechos>
	 */
	@Transactional(rollbackFor = Throwable.class)
	public List<Derechos> cargarCombo(Derechos derechos) {
		return this.derechosDao.cargarCombo(derechos);
	}

	@Override
	public List<Derechos> findDescripciones(String derechosString) {
		return this.derechosDao.findDescripciones(derechosString);
	}

	/**
	 * Filter method in the Derechos table.
	 *
	 * @param filterDerechos
	 *            Derechos
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<Derechos>
	 */
	public List<Derechos> cargarComboDerechos(Derechos filterDerechos, TableRequestDto tableRequestDto) {
		return this.derechosDao.cargarComboDerechos(filterDerechos, tableRequestDto);
	}
}
