package com.ejie.ab59.service.tablasMaestras;

import java.util.List;

import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */

public interface DerechosService {

	/**
	 * Filter method in the Derechos table.
	 *
	 * @param filterDerechos
	 *            Derechos
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<Derechos>
	 */
	TableResponseDto<Derechos> filter(Derechos filterDerechos, TableRequestDto tableRequestDto);

	/**
	 * Inserts a single row in the Derechos table.
	 *
	 * @param derecho
	 *            Derechos
	 * @return Derechos
	 */
	Derechos add(Derechos derecho);

	/**
	 * Finds a single row in the Derechos table.
	 *
	 * @param derechos
	 *            Derechos
	 * @return Derechos
	 */
	Derechos find(Derechos derechos);

	/**
	 * Updates a single row in the Derechos table.
	 *
	 * @param derecho
	 *            Derechos
	 * @return Derechos
	 */
	Derechos update(Derechos derecho);

	/**
	 * Baja lógica del registro
	 *
	 * @param derecho
	 *            Derechos
	 */
	void remove(Derechos derecho);

	/**
	 * Finds a list of rows in the Derechos table.
	 *
	 * @param derechos
	 *            Derechos
	 * 
	 * @return List<Derechos>
	 */
	List<Derechos> cargarCombo(Derechos derechos);

	List<Derechos> findDescripciones(String derechosString);

	List<Derechos> cargarComboDerechos(Derechos filterDerechos, TableRequestDto tableRequestDto);
}
