package com.ejie.ab59.service.tablasMaestras;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.tablasMaestras.ConfIniOfiDao;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.tablasMaestras.ConfIniOfi;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * ConfIniOfiServiceImpl  
 * 
 *  
 */

@Service(value = "confIniOfiService")
public class ConfIniOfiServiceImpl implements ConfIniOfiService {

	@Autowired
	private ConfIniOfiDao confIniOfiDao;

	/**
	 * Inserts a single row in the ConfIniOfi table.
	 *
	 * @param confIniOfi
	 *            ConfIniOfi
	 * @return ConfIniOfi
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ConfIniOfi add(ConfIniOfi confIniOfi) {
		return this.confIniOfiDao.add(confIniOfi);
	}

	/**
	 * Updates a single row in the ConfIniOfi table.
	 *
	 * @param confIniOfi
	 *            ConfIniOfi
	 * @return ConfIniOfi
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ConfIniOfi update(ConfIniOfi confIniOfi) {
		return this.confIniOfiDao.update(confIniOfi);
	}

	/**
	 * Finds a single row in the ConfIniOfi table.
	 *
	 * @param confIniOfi
	 *            ConfIniOfi
	 * @return ConfIniOfi
	 */
	public ConfIniOfi find(ConfIniOfi confIniOfi) {
		return (ConfIniOfi) this.confIniOfiDao.find(confIniOfi);
	}

	/**
	 * Deletes a single row in the ConfIniOfi table.
	 *
	 * @param confIniOfi
	 *            ConfIniOfi
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ConfIniOfi confIniOfi) {
		this.confIniOfiDao.remove(confIniOfi);
	}

	/**
	 * Finds a list of rows in the ConfIniOfi table.
	 *
	 * @param confIniOfi
	 *            ConfIniOfi
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<ConfIniOfi>
	 */
	public List<ConfIniOfi> findAll(ConfIniOfi confIniOfi, TableRequestDto tableRequestDto) {
		return (List<ConfIniOfi>) this.confIniOfiDao.findAll(confIniOfi, tableRequestDto);
	}

	@Override
	public TableResponseDto<ConfIniOfi> filter(ConfIniOfi filterTiposFinalizacion, TableRequestDto tableRequestDto) {

		List<ConfIniOfi> listaTiposFinalizacion = this.confIniOfiDao.findAll(filterTiposFinalizacion, tableRequestDto);
		Long recordNum = this.confIniOfiDao
				.findAllCount(filterTiposFinalizacion != null ? filterTiposFinalizacion : new ConfIniOfi());

		return new TableResponseDto<ConfIniOfi>(tableRequestDto, recordNum, listaTiposFinalizacion);

	}

	@Override
	public ConfIniOfi findByProcedimiento(Procedimientos procedimiento) {
		return this.confIniOfiDao.findByProcedimiento(procedimiento);
	}

	@Override
	public List<String> findTiposAlcanceResolucion(Procedimientos procedimiento) {
		return this.confIniOfiDao.findTiposAlcanceResolucion(procedimiento);
	}

}
