package com.ejie.ab59.service.tablasMaestras;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.tablasMaestras.CalificacionesDao;
import com.ejie.ab59.model.tablasMaestras.Calificaciones;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * CalificacionesServiceImpl  
 * 
 *  
 */

@Service(value = "calificacionesService")
public class CalificacionesServiceImpl implements CalificacionesService {

	@Autowired
	private CalificacionesDao calificacionesDao;

	/**
	 * Inserts a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Calificaciones add(Calificaciones calificaciones) {
		return this.calificacionesDao.add(calificaciones);
	}

	/**
	 * Updates a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Calificaciones update(Calificaciones calificaciones) {
		return this.calificacionesDao.update(calificaciones);
	}

	/**
	 * Finds a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	public Calificaciones find(Calificaciones calificaciones) {
		return this.calificacionesDao.find(calificaciones);
	}

	/**
	 * Finds a list of rows in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Calificaciones>
	 */
	public List<Calificaciones> findAll(Calificaciones calificaciones, TableRequestDto tableRequestDto) {
		return (List<Calificaciones>) this.calificacionesDao.findAll(calificaciones, tableRequestDto);
	}

	/**
	 * Filter method in the Calificaciones table.
	 *
	 * @param filterCalificaciones
	 *            Calificaciones
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<Calificaciones>
	 */
	public TableResponseDto<Calificaciones> filter(Calificaciones filterCalificaciones,
			TableRequestDto tableRequestDto) {
		List<Calificaciones> listaCalificaciones = this.calificacionesDao.findAll(filterCalificaciones,
				tableRequestDto);
		Long recordNum = this.calificacionesDao
				.findAllCount(filterCalificaciones != null ? filterCalificaciones : new Calificaciones());

		return new TableResponseDto<Calificaciones>(tableRequestDto, recordNum, listaCalificaciones);
	}

	/**
	 * Obtener la calificación más grave entra las infracciones pasadas
	 * 
	 * @param idsInfracciones
	 *            String
	 * @return Calificaciones
	 */
	public Calificaciones obtenerCalificacionGraveInfracciones(String infracciones) {
		return this.calificacionesDao.obtenerCalificacionGraveInfracciones(infracciones);
	}

	/**
	 * Finds a list of rows in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * 
	 * @return List<Calificaciones>
	 */
	public List<Calificaciones> cargarCombo(Calificaciones calificaciones) {
		return this.calificacionesDao.cargarCombo(calificaciones);
	}

	/**
	 * Finds a single row in the Calificaciones table.
	 *
	 * @param idInfraccion
	 *            Integer
	 * 
	 * @return Calificaciones
	 */
	public Calificaciones findCalificacionByInfraccion(Integer idInfraccion) {
		return this.calificacionesDao.findCalificacionByInfraccion(idInfraccion);
	}

}
