package com.ejie.ab59.service.tablasMaestras;

import java.util.List;

import com.ejie.ab59.model.tablasMaestras.Calificaciones;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * CalificacionesService  
 * 
 *  
 */

public interface CalificacionesService {

	/**
	 * Inserts a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	Calificaciones add(Calificaciones calificaciones);

	/**
	 * Updates a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	Calificaciones update(Calificaciones calificaciones);

	/**
	 * Finds a single row in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @return Calificaciones
	 */
	Calificaciones find(Calificaciones calificaciones);

	/**
	 * Finds a list of rows in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Calificaciones>
	 */
	List<Calificaciones> findAll(Calificaciones calificaciones, TableRequestDto tableRequestDto);

	/**
	 * Filter method in the Calificaciones table.
	 *
	 * @param filterCalificaciones
	 *            Calificaciones
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<Calificaciones>
	 */
	TableResponseDto<Calificaciones> filter(Calificaciones filterCalificaciones, TableRequestDto tableRequestDto);

	/**
	 * Obtener la calificación más grave entra las infracciones pasadas
	 * 
	 * @param idsInfracciones
	 *            String
	 * @return Calificaciones
	 */
	Calificaciones obtenerCalificacionGraveInfracciones(String infracciones);

	/**
	 * Finds a list of rows in the Calificaciones table.
	 *
	 * @param calificaciones
	 *            Calificaciones
	 * 
	 * @return List<Calificaciones>
	 */
	List<Calificaciones> cargarCombo(Calificaciones calificaciones);

	/**
	 * Finds a single row in the Calificaciones table.
	 *
	 * @param idInfraccion
	 *            Integer
	 * 
	 * @return Calificaciones
	 */
	Calificaciones findCalificacionByInfraccion(Integer idInfraccion);

}
