package com.ejie.ab59.service.serviciosWeb;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.exceptions.Ab59Exception;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.plantillas.Plantillas;
import com.ejie.ab59.model.propuestasSancion.DocProSan;
import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.propuestasSancion.RelArtInfProSan;
import com.ejie.ab59.model.propuestasSancion.RelArtInfProSanDer;
import com.ejie.ab59.model.propuestasSancion.RelProSanFec;
import com.ejie.ab59.model.propuestasSancion.RelProSanSan;
import com.ejie.ab59.model.servicioWeb.PropuestaSancionIdentificadoresWS;
import com.ejie.ab59.model.servicioWeb.PropuestaSancionWS;
import com.ejie.ab59.model.tablasMaestras.Derechos;
import com.ejie.ab59.model.tablasMaestras.Infracciones;
import com.ejie.ab59.service.expedientes.ExpedientesService;
import com.ejie.ab59.service.propuestasSancion.DocProSanService;
import com.ejie.ab59.service.propuestasSancion.PropuestasSancionService;
import com.ejie.ab59.service.propuestasSancion.RelArtInfProSanDerService;
import com.ejie.ab59.service.propuestasSancion.RelArtInfProSanService;
import com.ejie.ab59.service.propuestasSancion.RelProSanFecService;
import com.ejie.ab59.service.propuestasSancion.RelProSanSanService;
import com.ejie.ab59.service.sanciones.RelSanProSanService;

@Service(value = "ServiciosWebService")
@SessionAttributes("usuario")
public class ServiciosWebServiceImpl implements ServiciosWebService {

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	private static final Logger logger = LoggerFactory.getLogger(ServiciosWebServiceImpl.class);

	@Autowired
	private PropuestasSancionService propuestasSancionService;
	@Autowired
	private ExpedientesService expedientesService;
	@Autowired
	private RelArtInfProSanService relArtInfProSanService;
	@Autowired
	private DocProSanService docProSanService;
	@Autowired
	private RelArtInfProSanDerService relArtInfProSanDerService;
	@Autowired
	private RelProSanSanService relProSanSanService;
	@Autowired
	private RelSanProSanService relSanProSanService;
	@Autowired
	private RelProSanFecService relProSanFecService;

	/* ****************************** */
	/* ** INICIO crearPropuestaSancion ** */
	/* ****************************** */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public PropuestaSancionIdentificadoresWS crearPropuestaSancion(PropuestaSancionWS objetoPropuestaSancion,
			String usuario, Integer idOrigenPropuestaSancion, Integer idTercero, Integer idDireccion)
			throws Ab59Exception {

		ServiciosWebServiceImpl.logger.info("Vamos a crear la propuesta de sanción");
		PropuestaSancionIdentificadoresWS retorno = null;

		String validacion = this.validarParametrosCrear(objetoPropuestaSancion, usuario, idOrigenPropuestaSancion);

		if (null == validacion || "" == validacion) {

			// sacamos el ID_EXPEDIENTE (ab611021T00) con el FOLDER_ID
			Expedientes expedientes = new Expedientes();
			expedientes.setFolderId(objetoPropuestaSancion.getFolderId());
			expedientes = expedientesService.findIdExpediente(expedientes);

			try {
				int anio;
				PropuestasSancion propuestaSancionAux = new PropuestasSancion();
				Date fechaHechoMasAntigua = this.calcularFechaHechoMasAntigua(objetoPropuestaSancion);

				if (fechaHechoMasAntigua != null) {
					Calendar cal = Calendar.getInstance();
					cal.setTime(fechaHechoMasAntigua);
					anio = cal.get(Calendar.YEAR);

					propuestaSancionAux = this.propuestasSancionService.findByAnio(String.valueOf(anio));
				} else {
					Date fechaAperturaMasActual = this.findFechaAperturaMasActual(expedientes);

					if (fechaAperturaMasActual != null) {
						Calendar cal = Calendar.getInstance();
						cal.setTime(fechaAperturaMasActual);
						anio = cal.get(Calendar.YEAR);

						propuestaSancionAux = this.propuestasSancionService.findByAnio(String.valueOf(anio));
					} else {
						Calendar cal = Calendar.getInstance();
						cal.setTime(new Date());
						anio = cal.get(Calendar.YEAR);

						propuestaSancionAux = this.propuestasSancionService.findByAnio(String.valueOf(anio));
					}
				}

				String identificadorProSan = "";
				String secuenciaIdentificadorStr = "";
				if (propuestaSancionAux != null) {
					// Tenemos propuesta en este ao
					if (!"".equals(propuestaSancionAux.getIdentificadorProSan())
							&& propuestaSancionAux.getIdentificadorProSan() != null) {

						Integer secuenciaIdentificador = Integer
								.parseInt(propuestaSancionAux.getIdentificadorProSan().split("-")[3]);
						secuenciaIdentificador += 1;

						switch (secuenciaIdentificador.toString().length()) {
						case 1:
							secuenciaIdentificadorStr = "00" + secuenciaIdentificador.toString();
							break;
						case 2:
							secuenciaIdentificadorStr = "0" + secuenciaIdentificador.toString();
							break;
						case 3:
							secuenciaIdentificadorStr = secuenciaIdentificador.toString();
							break;

						default:
							break;
						}

						identificadorProSan = Constantes.IDENTIFICADOR_PRO_SAN_P_T + String.valueOf(anio) + "-"
								+ secuenciaIdentificadorStr;

					}

				} else {
					// No tenemos propuesta en este ao
					identificadorProSan = Constantes.IDENTIFICADOR_PRO_SAN_P_T + String.valueOf(anio) + "-001";
				}

				/* INICIO Agregar propuesta de sanción (AB5902T00) */
				PropuestasSancion propuestaSancion = new PropuestasSancion();
				propuestaSancion.setIdentificadorProSan(identificadorProSan);
				propuestaSancion.setIdentificadorInspeccion(objetoPropuestaSancion.getIdentificadorInspeccion());
				propuestaSancion.setNotasRespOfi(objetoPropuestaSancion.getNotasResponsableOficina());
				propuestaSancion.setIdOrigenProSancion(idOrigenPropuestaSancion);
				propuestaSancion.setIdTipoEstablecimiento(objetoPropuestaSancion.getIdTipoActividad());
				propuestaSancion.setEstado(Constantes.ESTADO_PDTE_DECISION);
				propuestaSancion.setUsuarioRegistro(usuario);

				if (null != expedientes) {
					Expedientes expedienteAux = new Expedientes();
					expedienteAux.setIdExpediente(expedientes.getIdExpediente());
					propuestaSancion.setExpedienteOrigen(expedienteAux);
				} else {
					propuestaSancion.setIdTercero(idTercero);
					propuestaSancion.setIdDireccion(idDireccion);
				}

				propuestaSancion = this.propuestasSancionService.add(propuestaSancion);

				/* Insertar AB5919T00 (REL_SAN_PRO_FEC) */
				RelProSanFec relProSanFec = new RelProSanFec();
				relProSanFec.setIdPropuestaSancion(propuestaSancion.getIdPropuestaSancion());
				relProSanFec.setTipoFecha(Constantes.FECHA_PROPUESTA_OT);
				relProSanFec.setUsuarioRegistro(usuario);
				this.relProSanFecService.add(relProSanFec);

				// Agregar registro en REL_PRO_SAN_SAN (AB6128T00)
				RelProSanSan relProSanSan = new RelProSanSan();
				relProSanSan.setIdentificadorInspeccion(objetoPropuestaSancion.getIdentificadorInspeccion());
				relProSanSan.setPropuestaSancion(propuestaSancion);
				relProSanSan.setEstado(Constantes.ESTADO_PDTE_DECISION);
				relProSanSan.setUsuarioRegistro(usuario);
				this.relProSanSanService.add(relProSanSan);

				/* FIN Agregar propuesta de sanción (AB5902T00) */

				/* Agregar artculos infringidos */
				this.agregarArticulosInfringidos(objetoPropuestaSancion, propuestaSancion.getIdPropuestaSancion(),
						usuario);

				/* Agregar documentos (AB5915T00) */
				this.agregarDocumentos(objetoPropuestaSancion, propuestaSancion.getIdPropuestaSancion(), usuario);

				/*
				 * Completamos el objeto a retornar ya que ahpora se retornan 2
				 * id
				 */
				retorno = new PropuestaSancionIdentificadoresWS();
				retorno.setIdPropuestaSancion(propuestaSancion.getIdPropuestaSancion());
				retorno.setIdentificadorProSan(propuestaSancion.getIdentificadorProSan());
			} catch (Exception e) {

				ServiciosWebServiceImpl.logger.error("Excepcion al insertar la Propuesta de Sancin" + e);

				String sCodigoError = "error.noControlado";

				ServiciosWebServiceImpl.logger.error(sCodigoError, e);

				retorno = null;

				throw new Ab59Exception(sCodigoError, appMessageSource.getMessage(sCodigoError, null, new Locale("es")),
						appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));

			}
			ServiciosWebServiceImpl.logger.info("[GET - insertar Propuesta de Sancin] insertardo");

		} else

		{
			String sCodigoError = validacion;

			ServiciosWebServiceImpl.logger.error("Crear Propuesta de Sanción - " + sCodigoError);

			retorno = null;

			throw new Ab59Exception(sCodigoError, appMessageSource.getMessage(sCodigoError, null, new Locale("es")),
					appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));
		}

		return retorno;
	}

	private Date findFechaAperturaMasActual(Expedientes expedientes) {
		Date fechaApertura = null;

		if (expedientes != null && expedientes.getIdExpediente() != null) {
			fechaApertura = this.propuestasSancionService.findFechaAperturaMasActual(expedientes.getIdExpediente());
		}

		return fechaApertura;
	}

	private Date calcularFechaHechoMasAntigua(PropuestaSancionWS objetoPropuestaSancion) {
		Date fechaHecho = null;

		for (int i = 0; i < objetoPropuestaSancion.getArticulosInfringidosWS().size(); i++) {
			if (i == 0) {
				fechaHecho = objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getFechaHecho();
			}
			if (objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getFechaHecho().before(fechaHecho)) {
				fechaHecho = objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getFechaHecho();
			}
		}

		return fechaHecho;
	}

	/**
	 * Validar los parámetros recibidos
	 *
	 * @param objetoPropuestaSancion
	 *            PropuestaSancionWS
	 * @param nombreUsuario
	 *            String
	 * @param idOrigenInspeccion
	 *            Integer
	 * 
	 * @return sCodigoError String
	 */
	private String validarParametrosCrear(PropuestaSancionWS objetoPropuestaSancion, String usuario,
			Integer idOrigenPropuestaSancion) {

		ServiciosWebServiceImpl.logger.info("Validar los parmetros recibidos");
		String sCodigoError = null;

		/* Obligatorios */
		if (null == objetoPropuestaSancion) {
			sCodigoError = "error.obligatorio.propuestaSancion";
		} else if (null == objetoPropuestaSancion.getIdentificadorInspeccion()) {
			sCodigoError = "error.obligatorio.identificadorInspeccion";
		} else if (null == objetoPropuestaSancion.getArticulosInfringidosWS()) {
			sCodigoError = "error.obligatorio.articulosInfringidos";
		} else if (null == usuario || "".equals(usuario)) {
			sCodigoError = "error.obligatorio.usuario";
		} else if (null == idOrigenPropuestaSancion || Constantes.MAGIC_NUMBER_0 == idOrigenPropuestaSancion) {
			sCodigoError = "error.obligatorio.idOrigenPropuestaSancion";
		}

		if (objetoPropuestaSancion != null && objetoPropuestaSancion.getArticulosInfringidosWS() != null) {
			for (int i = 0; i < objetoPropuestaSancion.getArticulosInfringidosWS().size(); i++) {
				if (null == objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getIdTipoInfraccion()
						|| Constantes.MAGIC_NUMBER_0 == objetoPropuestaSancion.getArticulosInfringidosWS().get(i)
								.getIdTipoInfraccion()) {
					sCodigoError = "error.obligatorio.articulosInfringidos.idTipoInfraccion";
				} else {
					if (objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDerechosInfringidosWS() != null) {
						for (int j = 0; j < objetoPropuestaSancion.getArticulosInfringidosWS().get(i)
								.getDerechosInfringidosWS().size(); j++) {
							if (null == objetoPropuestaSancion.getArticulosInfringidosWS().get(i)
									.getDerechosInfringidosWS().get(j).getIdDerechoInfringido()
									|| Constantes.MAGIC_NUMBER_0 == objetoPropuestaSancion.getArticulosInfringidosWS()
											.get(i).getDerechosInfringidosWS().get(j).getIdDerechoInfringido()) {
								sCodigoError = "error.obligatorio.articulosInfringidos.derecho";
							}
						}
					} else {
						sCodigoError = "error.obligatorio.articulosInfringidos.derecho";
					}
				}
			}
		}

		if (objetoPropuestaSancion != null && objetoPropuestaSancion.getDocumentosWS() != null) {
			for (int i = 0; i < objetoPropuestaSancion.getDocumentosWS().size(); i++) {
				if (null == objetoPropuestaSancion.getDocumentosWS().get(i).getNombreDocumento()) {
					sCodigoError = "error.obligatorio.documentos.nombreDocumento";
				}
			}
		}

		return sCodigoError;
	}
	/* *************************** */
	/* ** FIN crearPropuestaSancion ** */
	/* ************************** */

	/* ********************************* */
	/* ** INICIO modificarPropuestaSancion ** */
	/* ********************************* */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public String modificarPropuestaSancion(PropuestaSancionWS objetoPropuestaSancion, String usuario,
			Integer idTercero, Integer idDireccion) throws Ab59Exception {

		ServiciosWebServiceImpl.logger.info("Vamos a modificar la propuesta de sanción");
		String idPropuestaSancion = null;

		String validacion = this.validarParametrosModificar(objetoPropuestaSancion, usuario);

		if (null == validacion || "" == validacion) {
			/* Actualizar AB5902T00 (PROPUESTAS_SANCION) */
			PropuestasSancion propuestaSancion = new PropuestasSancion();
			propuestaSancion.setIdPropuestaSancion(objetoPropuestaSancion.getIdPropuestaSancion());
			propuestaSancion.setNotasRespOfi(objetoPropuestaSancion.getNotasResponsableOficina());
			propuestaSancion.setUsuarioUltmodificacion(usuario);
			propuestaSancion.setIdTercero(idTercero);
			propuestaSancion.setIdDireccion(idDireccion);

			this.propuestasSancionService.updatePropuestaSancion(propuestaSancion);

			PropuestasSancion propuestaSancionAux = this.propuestasSancionService.find(propuestaSancion);

			RelProSanSan relProSanSan = new RelProSanSan();
			relProSanSan.setUsuarioUltModificacion(usuario);

			if (Constantes.ESTADO_REQUERIMIENTO_SUBSANACION_TURISMO.equals(propuestaSancionAux.getEstado())) {
				propuestaSancion.setEstado(Constantes.ESTADO_PENDIENTE_DECISION_TURISMO);
				relProSanSan.setEstado(Constantes.ESTADO_PENDIENTE_DECISION_TURISMO);
				relProSanSan.setPropuestaSancion(propuestaSancion);
				this.propuestasSancionService.updateEstadoProSan(propuestaSancion);

				/* Actualizar AB6128T00 (REL_PRO_SAN_SAN) */
				this.relProSanSanService.updateByPropuestaSancion(relProSanSan);
			} else if (Constantes.ESTADO_REQUERIMIENTO_SUBSANACION_COMERCIO.equals(propuestaSancionAux.getEstado())) {
				propuestaSancion.setEstado(Constantes.ESTADO_PENDIENTE_DECISION_COMERCIO);
				relProSanSan.setEstado(Constantes.ESTADO_PENDIENTE_DECISION_COMERCIO);
				relProSanSan.setPropuestaSancion(propuestaSancion);
				this.propuestasSancionService.updateEstadoProSan(propuestaSancion);

				/* Actualizar AB6128T00 (REL_PRO_SAN_SAN) */
				this.relProSanSanService.updateByPropuestaSancion(relProSanSan);
			}

			/* Insertar AB5919T00 (REL_SAN_PRO_FEC) */
			RelProSanFec relProSanFec = new RelProSanFec();
			relProSanFec.setIdPropuestaSancion(propuestaSancion.getIdPropuestaSancion());
			relProSanFec.setTipoFecha(Constantes.FECHA_PROPUESTA_OT);
			relProSanFec.setUsuarioRegistro(usuario);
			this.relProSanFecService.add(relProSanFec);

			/* Eliminar datos relacionados */
			// Eliminar AB5916T00 (REL_ART_INF_PRO_SAN_DER)
			this.relArtInfProSanDerService.removeByPropuestaSancion(objetoPropuestaSancion.getIdPropuestaSancion());
			// Eliminar AB5910T00 (REL_ART_INF_PRO_SAN)
			this.relArtInfProSanService.removeByPropuestaSancion(objetoPropuestaSancion.getIdPropuestaSancion());
			// Eliminar AB5915T00 (DOC_PRO_SAN)
			this.docProSanService.removeByPropuestaSancion(objetoPropuestaSancion.getIdPropuestaSancion());

			/* Insertar datos relacionados */
			// Insertar AB5915T00 (DOC_PRO_SAN)
			this.agregarDocumentos(objetoPropuestaSancion, objetoPropuestaSancion.getIdPropuestaSancion(), usuario);
			/* Agregar artículos infringidos */
			this.agregarArticulosInfringidos(objetoPropuestaSancion, objetoPropuestaSancion.getIdPropuestaSancion(),
					usuario);

			idPropuestaSancion = "OK";

		} else

		{
			String sCodigoError = validacion;

			ServiciosWebServiceImpl.logger.error("Modificar Propuesta de Sanción - ", sCodigoError);

			idPropuestaSancion = null;

			throw new Ab59Exception(sCodigoError, appMessageSource.getMessage(sCodigoError, null, new Locale("es")),
					appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));
		}

		return idPropuestaSancion;
	}

	/**
	 * Validar los parámetros recibidos
	 * 
	 * @param objetoPropuestaSancion
	 *            PropuestaSancionWS
	 * @param nombreUsuario
	 *            String
	 * 
	 * @return sCodigoError String
	 */
	private String validarParametrosModificar(PropuestaSancionWS objetoPropuestaSancion, String usuario) {

		ServiciosWebServiceImpl.logger.info("Validar los parámetros recibidos");
		String sCodigoError = null;

		/* Obligatorios */
		if (null == objetoPropuestaSancion) {
			sCodigoError = "error.obligatorio.propuestaSancion";
		} else if (Constantes.MAGIC_NUMBER_0 == objetoPropuestaSancion.getIdPropuestaSancion()) {
			sCodigoError = "error.obligatorio.idPropuestaSancion";
		} else if (null == objetoPropuestaSancion.getArticulosInfringidosWS()) {
			sCodigoError = "error.obligatorio.articulosInfringidos";
		} else if (null == usuario || "".equals(usuario)) {
			sCodigoError = "error.obligatorio.usuario";
		}

		if (objetoPropuestaSancion != null && objetoPropuestaSancion.getArticulosInfringidosWS() != null) {
			for (int i = 0; i < objetoPropuestaSancion.getArticulosInfringidosWS().size(); i++) {
				if (null == objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getIdTipoInfraccion()
						|| Constantes.MAGIC_NUMBER_0 == objetoPropuestaSancion.getArticulosInfringidosWS().get(i)
								.getIdTipoInfraccion()) {
					sCodigoError = "error.obligatorio.articulosInfringidos.idTipoInfraccion";
				} else {
					if (objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDerechosInfringidosWS() != null) {
						for (int j = 0; j < objetoPropuestaSancion.getArticulosInfringidosWS().get(i)
								.getDerechosInfringidosWS().size(); j++) {
							if (null == objetoPropuestaSancion.getArticulosInfringidosWS().get(i)
									.getDerechosInfringidosWS().get(j).getIdDerechoInfringido()
									|| Constantes.MAGIC_NUMBER_0 == objetoPropuestaSancion.getArticulosInfringidosWS()
											.get(i).getDerechosInfringidosWS().get(j).getIdDerechoInfringido()) {
								sCodigoError = "error.obligatorio.articulosInfringidos.derecho";
							}
						}
					} else {
						sCodigoError = "error.obligatorio.articulosInfringidos.derecho";
					}
				}
			}
		}

		if (objetoPropuestaSancion != null && objetoPropuestaSancion.getDocumentosWS() != null) {
			for (int i = 0; i < objetoPropuestaSancion.getDocumentosWS().size(); i++) {
				if (null == objetoPropuestaSancion.getDocumentosWS().get(i).getNombreDocumento()) {
					sCodigoError = "error.obligatorio.documentos.nombreDocumento";
				}
			}
		}

		/* La propuesta existe */
		if (sCodigoError == null) {
			if (this.propuestasSancionService
					.validarExistePropuesta(objetoPropuestaSancion.getIdPropuestaSancion()) == 0) {
				sCodigoError = "error.propuestaSancion.noExiste";
			}
		}

		/* Estado != 4 (Validado por Asesoría Jurídica */
		if (sCodigoError == null) {
			if (this.propuestasSancionService
					.validarEstadoValidadaOSancionador(objetoPropuestaSancion.getIdPropuestaSancion()) == 0) {
				sCodigoError = "error.propuestaSancion.estadoValidada";
			}
		}

		return sCodigoError;
	}
	/* ****************************** */
	/* ** FIN modificarPropuestaSancion ** */
	/* ***************************** */

	/* ******************************** */
	/* ** INICIO eliminarPropuestaSancion ** */
	/* ******************************** */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public String eliminarPropuestaSancion(Integer idPropuestaSancion, String usuario) throws Ab59Exception {

		ServiciosWebServiceImpl.logger.info("Vamos a eliminar la propuesta de sanción");

		String eliminar = null;
		String validacion = this.validarParametrosEliminar(idPropuestaSancion, usuario);

		if (null == validacion || "" == validacion) {

			/* Eliminar informacin relacionada */
			// Eliminar AB5916T00 (REL_ART_INF_PRO_SAN_DER)
			this.relArtInfProSanDerService.removeByPropuestaSancion(idPropuestaSancion);
			// Eliminar AB5910T00 (REL_ART_INF_PRO_SAN)
			this.relArtInfProSanService.removeByPropuestaSancion(idPropuestaSancion);
			// Eliminar AB5915T00 (DOC_PRO_SAN)
			this.docProSanService.removeByPropuestaSancion(idPropuestaSancion);
			// Eliminar AB6128T00 (REL_PRO_SAN_SAN)
			this.relProSanSanService.removeByPropuestaSancion(idPropuestaSancion);
			// Eliminar AB5906T00 (REL_SAN_PRO_SAN)
			this.relSanProSanService.removeByPropuestaSancion(idPropuestaSancion);
			// Eliminar AB5919T00 (REL_PRO_SAN_FEC)
			this.relProSanFecService.removeByPropuestaSancion(idPropuestaSancion);

			/* Eliminar AB5902T00 (PROPUESTAS_SANCION) */
			PropuestasSancion propuestaSancion = new PropuestasSancion();
			propuestaSancion.setIdPropuestaSancion(idPropuestaSancion);
			this.propuestasSancionService.remove(propuestaSancion);

			eliminar = "OK";

		} else

		{
			String sCodigoError = validacion;

			ServiciosWebServiceImpl.logger.error("Eliminar Propuesta de Sanción - " + sCodigoError);

			throw new Ab59Exception(sCodigoError, appMessageSource.getMessage(sCodigoError, null, new Locale("es")),
					appMessageSource.getMessage(sCodigoError, null, new Locale("eu")));
		}

		return eliminar;
	}

	/**
	 * Validar los parámetros recibidos
	 * 
	 * @param idPropuestaSancion
	 *            Integer
	 * @param nombreUsuario
	 *            String
	 * 
	 * @return sCodigoError String
	 */
	private String validarParametrosEliminar(Integer idPropuestaSancion, String usuario) {

		ServiciosWebServiceImpl.logger.info("Validar los parámetros recibidos");
		String sCodigoError = null;

		/* Obligatorios */
		if (Constantes.MAGIC_NUMBER_0 == idPropuestaSancion) {
			sCodigoError = "error.obligatorio.propuestaSancion";
		} else if (null == usuario || "".equals(usuario)) {
			sCodigoError = "error.obligatorio.usuario";
		}

		/* La propuesta existe */
		if (sCodigoError == null) {
			if (this.propuestasSancionService.validarExistePropuesta(idPropuestaSancion) == 0) {
				sCodigoError = "error.propuestaSancion.noExiste";
			}
		}

		/* Estado != 4 (Validado por Asesoría Jurídica */
		if (sCodigoError == null) {
			if (this.propuestasSancionService.validarEstadoValidadaOSancionador(idPropuestaSancion) == 0) {
				sCodigoError = "error.propuestaSancion.estadoValidada";
			}
		}

		return sCodigoError;
	}
	/* ***************************** */
	/* ** FIN eliminarPropuestaSancion ** */
	/* **************************** */

	private void agregarDocumentos(PropuestaSancionWS objetoPropuestaSancion, Integer idPropuestaSancion,
			String usuario) {

		for (int i = 0; i < objetoPropuestaSancion.getDocumentosWS().size(); i++) {
			DocProSan documentos = new DocProSan();
			documentos.setOidPID(objetoPropuestaSancion.getDocumentosWS().get(i).getOidPID());
			documentos.setPlantilla(new Plantillas(objetoPropuestaSancion.getDocumentosWS().get(i).getTipoDocumento()));
			documentos.setDescTipoDocumento(objetoPropuestaSancion.getDocumentosWS().get(i).getDescTipoDocumento());
			documentos.setNombreDocumento(objetoPropuestaSancion.getDocumentosWS().get(i).getNombreDocumento());
			documentos.setOidDokusi(objetoPropuestaSancion.getDocumentosWS().get(i).getOidDokusi());
			documentos.setPropuestaSancion(new PropuestasSancion(idPropuestaSancion));
			documentos.setAportadoExpediente(Constantes.DOCUMENTO_NO_APORTADO_EXPEDIENTE);

			documentos.setUsuarioRegistro(usuario);

			this.docProSanService.add(documentos);
		}
	}

	private void agregarArticulosInfringidos(PropuestaSancionWS objetoPropuestaSancion, Integer idPropuestaSancion,
			String usuario) {

		/* INICIO Agregar artículos infringidos (AB5910T00) */
		for (int i = 0; i < objetoPropuestaSancion.getArticulosInfringidosWS().size(); i++) {
			RelArtInfProSan articulosInfringidos = new RelArtInfProSan();
			articulosInfringidos.setInfraccion(
					new Infracciones(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getIdTipoInfraccion()));
			articulosInfringidos
					.setNotasArticulo(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getNotasArticulo());
			articulosInfringidos.setPropuestaSancion(new PropuestasSancion(idPropuestaSancion));
			articulosInfringidos
					.setFechaHecho(objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getFechaHecho());
			articulosInfringidos.setDescripcionHecho(
					objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDescripcionHecho());

			articulosInfringidos.setUsuarioRegistro(usuario);

			this.relArtInfProSanService.add(articulosInfringidos);

			/* INICIO Agregar derechos infringidos (AB5916T00) */
			for (int j = 0; j < objetoPropuestaSancion.getArticulosInfringidosWS().get(i).getDerechosInfringidosWS()
					.size(); j++) {
				RelArtInfProSanDer derechosInfringidos = new RelArtInfProSanDer();
				derechosInfringidos.setRelArtInfProSan(articulosInfringidos);
				derechosInfringidos.setDerecho(new Derechos(objetoPropuestaSancion.getArticulosInfringidosWS().get(i)
						.getDerechosInfringidosWS().get(j).getIdDerechoInfringido()));

				this.relArtInfProSanDerService.add(derechosInfringidos);
			}
			/* FIN Agregar derechos infringidos (AB5916T00) */
		}

		/* FIN Agregar artículos infringidos (AB5910T00) */

	}
}