package com.ejie.ab59.service.sanciones;

import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.springframework.ui.Model;

import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.procedimientos.Direcciones;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * SancionesService  
 * 
 *  
 */

public interface SancionesService {

	Sanciones add(Sanciones sanciones);

	Sanciones find(Sanciones sanciones);

	void remove(Sanciones sanciones);

	List<Sanciones> findAll(Sanciones sanciones, TableRequestDto tableRequestDto);

	TableResponseDto<Sanciones> filter(Sanciones filterSanciones, TableRequestDto tableRequestDto);

	void getExcel(List<Sanciones> sanciones, HttpServletResponse response);

	Sanciones findDatosSancion(Sanciones sanciones);

	Sanciones updateDatosSancion(Sanciones sanciones);

	Boolean tieneDireccion(Sanciones sanciones);

	Sanciones obtenerCabeceraSancion(Integer idSancion);

	Sanciones findByFolderId(Sanciones sanciones);

	Sanciones obtenerCabeceraSancionByExpediente(Expedientes expediente);

	List<Sanciones> findExpedientesPartesInculpadas(List<String> documentos, Integer idExpediente,
			Direcciones direccion);

	/**
	 * Actualizar importes de la sancion
	 */
	Sanciones updateImportes(Sanciones sancion);

	/**
	 * Calcularemos el importe de la resolucion
	 */
	Sanciones calcularImporteResolucion(Sanciones sanciones);
	
	/**
	 * Comprobaremos si el expediente sancionador esta listo para el pago
	 * @param expediente
	 * @param model
	 * @return
	 */
	boolean validarExpedienteSancionadorListoParaElPago(Sanciones sancion, Model model);
}
