package com.ejie.ab59.service.sanciones;

import java.util.Calendar;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.expedientes.DatosDireccionesDao;
import com.ejie.ab59.dao.expedientes.RelExpDirDao;
import com.ejie.ab59.dao.propuestasSancion.PropuestasSancionDao;
import com.ejie.ab59.dao.propuestasSancion.RelArtInfProSanDerDao;
import com.ejie.ab59.dao.propuestasSancion.RelProSanSanDao;
import com.ejie.ab59.dao.sanciones.RelArtInfSanDerDao;
import com.ejie.ab59.dao.sanciones.RelSanProSanDao;
import com.ejie.ab59.dao.sanciones.SancionesDao;
import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.RelExpDir;
import com.ejie.ab59.model.propuestasSancion.RelArtInfProSanDer;
import com.ejie.ab59.model.propuestasSancion.RelProSanSan;
import com.ejie.ab59.model.sanciones.RelArtInfSan;
import com.ejie.ab59.model.sanciones.RelArtInfSanDer;
import com.ejie.ab59.model.sanciones.RelSanProSan;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * RelSanProSanServiceImpl  
 * 
 *  
 */

@Service(value = "relSanProSanService")
public class RelSanProSanServiceImpl implements RelSanProSanService {

	private static final Logger logger = LoggerFactory.getLogger(RelSanProSanServiceImpl.class);

	@Autowired
	private RelSanProSanDao relSanProSanDao;
	@Autowired
	private DatosDireccionesDao datosDireccionesDao;
	@Autowired
	private SancionesDao sancionesDao;
	@Autowired
	private RelArtInfProSanDerDao relArtInfProSanDerDao;
	@Autowired
	private RelArtInfSanDerDao relArtInfSanDerDao;
	@Autowired
	private RelArtInfSanService relArtInfSanService;
	@Autowired
	private RelExpDirDao relExpDirDao;
	@Autowired
	private PropuestasSancionDao propuestasSancionDao;
	@Autowired
	private RelProSanSanDao relProSanSanDao;

	/**
	 * Inserts a single row in the RelSanProSan table.
	 *
	 * @param relSanProSan
	 *            RelSanProSan
	 * @return RelSanProSan
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public RelSanProSan add(RelSanProSan relSanProSan, Integer tratarUbicacion) {

		/* Agregar registro en REL_SAN_PRO_SAN */
		relSanProSan = this.relSanProSanDao.add(relSanProSan);

		if (tratarUbicacion == 1) {
			this.actualizarDatosPropuesta(relSanProSan, false);
		}

		this.propuestasSancionDao.updateEstadoProSan(relSanProSan.getPropuestaSancion());

		// ACTUALIZAR REL_PRO_SAN_SAN (AB6128T00)
		RelProSanSan relProSanSan = new RelProSanSan();
		relProSanSan.setPropuestaSancion(relSanProSan.getPropuestaSancion());
		if (relSanProSan.getPropuestaSancion() != null) {
			relProSanSan.setEstado(relSanProSan.getPropuestaSancion().getEstado());
		}
		relProSanSan.setUsuarioUltModificacion(relSanProSan.getUsuarioRegistro());
		this.relProSanSanDao.updateByPropuestaSancion(relProSanSan);

		this.insertarInfraccionesInfringidas(relSanProSan);

		return relSanProSan;
	}

	/**
	 * Deletes a single row in the RelSanProSan table.
	 *
	 * @param relSanProSan
	 *            RelSanProSan
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RelSanProSan relSanProSan) {
		this.relSanProSanDao.remove(relSanProSan);

		this.propuestasSancionDao.updateEstadoProSan(relSanProSan.getPropuestaSancion());
	}

	private void actualizarDatosPropuesta(RelSanProSan relSanProSan, boolean esEliminar) {
		/* Actualizar datos de la sancin */
		RelSanProSan relSanProSanAux = new RelSanProSan();
		// direccion de la propuesta a aadir
		DatosDirecciones datosDireccionesNew = new DatosDirecciones();

		List<RelSanProSan> listaRelSanProSan = this.relSanProSanDao.findAll(relSanProSan, null);

		Boolean direccionCargada = false;
		RelSanProSanServiceImpl.logger.info("Direccion a insertar = " + listaRelSanProSan.size());
		for (int i = 0; i < listaRelSanProSan.size(); i++) {
			relSanProSanAux = listaRelSanProSan.get(i);

			if (relSanProSanAux.getIdRelSanProSan().equals(relSanProSan.getIdRelSanProSan())) {
				datosDireccionesNew = relSanProSanAux.getPropuestaSancion().getExpedienteOrigen().getDatosDirecciones();
				RelSanProSanServiceImpl.logger.info("Direccion a insertar = " + datosDireccionesNew.toString());
				break;
			}
		}

		List<DatosDirecciones> direccionesMismoEstablecimiento = this.datosDireccionesDao
				.findDireccionesSancionEstablecimiento(relSanProSan.getSancion().getIdSancion(),
						datosDireccionesNew.getIdentificadorEstablecimiento());

		// Si ya existe el establecimiento, no guardar
		if (!direccionesMismoEstablecimiento.isEmpty()) {
			direccionCargada = true;
		}

		Sanciones datosExpedienteSan = new Sanciones();

		/* La ubicacin sólo se asignar si no tiene ya una */
		/* Se coge la primera ubicacin de tipo 2 */
		if (!direccionCargada) {
			/* Insertar en DATOS_DIRECCIONES y actualizar en SANCIONES */

			datosDireccionesNew.setUsuarioRegistro(relSanProSan.getUsuarioRegistro());

			datosDireccionesNew = this.datosDireccionesDao.add(datosDireccionesNew);
			datosExpedienteSan = this.sancionesDao.obtenerCabeceraSancion(relSanProSan.getSancion().getIdSancion());
			RelExpDir relExpDir = new RelExpDir();
			relExpDir.setIdExpediente(datosExpedienteSan.getExpediente().getIdExpediente());
			relExpDir.setIdDireccion(datosDireccionesNew.getIdDireccion());
			relExpDir.setUsuarioRegistro(relSanProSan.getUsuarioRegistro());
			this.relExpDirDao.add(relExpDir);

		}

	}

	private void insertarInfraccionesInfringidas(RelSanProSan relSanProSan) {

		/* Obtener los derechos infringidos por la propuesta */
		List<RelArtInfProSanDer> relArtInfProSanDerList = this.relArtInfProSanDerDao
				.findAll(relSanProSan.getPropuestaSancion().getIdPropuestaSancion());

		/* Obtener los derechos infringidos por la sanción */
		List<RelArtInfSanDer> relArtInfSanDerList = this.relArtInfSanDerDao
				.findAll(relSanProSan.getSancion().getIdSancion());

		Boolean insertarDerecho = true;
		Calendar cal = Calendar.getInstance();

		for (RelArtInfProSanDer relArtInfProSanDerAux : relArtInfProSanDerList) {

			for (RelArtInfSanDer relArtInfSanDerAux : relArtInfSanDerList) {
				if (relArtInfProSanDerAux.getRelArtInfProSan().getInfraccion().getIdInfraccion() == relArtInfSanDerAux
						.getRelArtInfSan().getInfraccion().getIdInfraccion()
						&& relArtInfProSanDerAux.getDerecho().getIdDerecho() == relArtInfSanDerAux.getDerecho()
								.getIdDerecho()) {
					insertarDerecho = false;
					break;
				} else {
					insertarDerecho = true;
				}
			}

			if (insertarDerecho) {
				/* Validar si la infracción ya está introducida */
				RelArtInfSan infraccionInfringida = this.relArtInfSanService.findInfraccionInfringida(
						relSanProSan.getSancion().getIdSancion(),
						relArtInfProSanDerAux.getRelArtInfProSan().getInfraccion().getIdInfraccion());

				if (infraccionInfringida == null) {
					/* Insertar la infracción */
					infraccionInfringida = new RelArtInfSan();
					infraccionInfringida.setInfraccion(relArtInfProSanDerAux.getRelArtInfProSan().getInfraccion());
					infraccionInfringida.setSancion(relSanProSan.getSancion());
					infraccionInfringida.setFechaHecho(relArtInfProSanDerAux.getRelArtInfProSan().getFechaHecho());
					infraccionInfringida
							.setDescripcionHecho(relArtInfProSanDerAux.getRelArtInfProSan().getDescripcionHecho());
					infraccionInfringida.setImporteSancionArt(relArtInfProSanDerAux.getRelArtInfProSan().getInfraccion()
							.getCalificaciones().getImporte());

					Calendar fechaPrescripcion = Calendar.getInstance();
					fechaPrescripcion.setTime(relArtInfProSanDerAux.getRelArtInfProSan().getFechaHecho());
					fechaPrescripcion.add(Calendar.YEAR, (int) (long) relArtInfProSanDerAux.getRelArtInfProSan()
							.getInfraccion().getCalificaciones().getPlazo());
					infraccionInfringida.setFechaPrescripcion(fechaPrescripcion.getTime());
					infraccionInfringida.setFechaRegistro(cal.getTime());
					infraccionInfringida.setUsuarioRegistro(relSanProSan.getUsuarioRegistro());

					infraccionInfringida = this.relArtInfSanService.add(infraccionInfringida);
				}

				/* Insertar el derecho/obligación */
				RelArtInfSanDer derechoInfringido = new RelArtInfSanDer();
				derechoInfringido.setRelArtInfSan(infraccionInfringida);
				derechoInfringido.setDerecho(relArtInfProSanDerAux.getDerecho());
				derechoInfringido.setFechaRegistro(cal.getTime());
				derechoInfringido.setUsuarioRegistro(relSanProSan.getUsuarioRegistro());
				this.relArtInfSanDerDao.add(derechoInfringido);
			}
		}

	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	/**
	 * Filter method in the RelSanProSan table.
	 *
	 * @param filterRelSanProSan
	 *            RelSanProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<RelSanProSan>
	 */
	@Override
	public TableResponseDto<RelSanProSan> filter(RelSanProSan filterRelSanProSan, TableRequestDto tableRequestDto) {
		List<RelSanProSan> listaRelSanProSan = this.relSanProSanDao.findAll(filterRelSanProSan, tableRequestDto);
		Long recordNum = this.relSanProSanDao
				.findAllCount(filterRelSanProSan != null ? filterRelSanProSan : new RelSanProSan());

		return new TableResponseDto<RelSanProSan>(tableRequestDto, recordNum, listaRelSanProSan);
	}

	@Override
	public void removeByPropuestaSancion(Integer idPropuestaSancion) {
		this.relSanProSanDao.removeByPropuestaSancion(idPropuestaSancion);
	}

	@Override
	public Long findAllCount(RelSanProSan relSanProSan) {
		return this.relSanProSanDao.findAllCount(relSanProSan);
	}

}
