package com.ejie.ab59.service.sanciones;

import java.util.List;

import com.ejie.ab59.model.sanciones.RelArtInfSan;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

public interface RelArtInfSanService {

	RelArtInfSan add(RelArtInfSan relArtInfSan);

	RelArtInfSan update(RelArtInfSan relArtInfSan);

	void remove(RelArtInfSan relArtInfSan);

	TableResponseDto<RelArtInfSan> filter(RelArtInfSan filterRelArtInfSan, TableRequestDto tableRequestDto);

	RelArtInfSan find(RelArtInfSan relArtInfSan);

	RelArtInfSan totales(RelArtInfSan relArtInfSan);

	RelArtInfSan updatePagos(RelArtInfSan relArtInfSan);

	/**
	 * Obtenemos el listado de RelArtInfSan
	 */
	List<RelArtInfSan> findAll(RelArtInfSan relArtInfSan);

	/**
	 * Calcularemos el importe de la resolucion de una infraccion
	 */
	RelArtInfSan calcularImporteResolucion(RelArtInfSan relArtInfSan);

	/**
	 * Calcularemos el importe de la resolucion de todas las infracciones de una
	 * sancion
	 */
	void actualizarImporteResolucionInfraccionesSancion(Integer idSancion);

	RelArtInfSan findInfraccionInfringida(Integer idSancion, Integer idInfraccion);
}
