package com.ejie.ab59.service.sanciones;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.w3c.dom.Document;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.SeguridadAplicacion;
import com.ejie.ab59.comun.UtilUsuario;
import com.ejie.ab59.comun.UtilsConfig;
import com.ejie.ab59.comun.UtilsXlnets;
import com.ejie.ab59.model.sanciones.RelSanProSan;
import com.ejie.ab59.model.sanciones.Sanciones;
import com.ejie.ab59.service.PerfilService;
import com.ejie.ab59.service.expedientes.ExpedientesService;
import com.ejie.ab59.service.sanciones.RelSanProSanService;
import com.ejie.x38.util.StaticsContainer;

/**
 * RelSanProSanServiceImpl  
 * 
 *  
 */

@Service(value = "fichaSancionService")
public class FichaSancionServiceImpl implements FichaSancionService {

	private static final Logger logger = LoggerFactory.getLogger(FichaSancionServiceImpl.class);

	@Autowired
	private RelSanProSanService relSanProSanService;

	@Autowired
	private ExpedientesService expedienteService;

	@Autowired
	private PerfilService perfilService;

	@Override
	public String fichaSancionView(HttpServletRequest httpRequest, Sanciones sancion, Model model,
			boolean irAExpediente) {

		if (SeguridadAplicacion.esPerfilConsulta()) {
			return "accessDenied";
		}

		Authentication aut = SecurityContextHolder.getContext().getAuthentication();
		FichaSancionServiceImpl.logger.info("autotenticación:getAuthentication" + aut);

		Usuario usuario = UtilUsuario.getUsuario(aut, httpRequest);

		model.addAttribute("usuario", usuario);

		if (sancion != null) {
			Integer idSancion = sancion.getIdSancion();
			String folderNumber = "";
			String titulo = "";
			String cabeceraSancionProcedimiento = "";
			if (sancion.getExpediente() != null) {
				if (sancion.getExpediente().getFolderNumber() != null) {
					folderNumber = sancion.getExpediente().getFolderNumber();
				}
				if (sancion.getExpediente().getTitulo() != null) {
					titulo = sancion.getExpediente().getTitulo();
				}

				String idioma = LocaleContextHolder.getLocale().getLanguage();
				if ("es".equalsIgnoreCase(idioma)) {
					if (sancion.getExpediente().getProcedimiento() != null
							&& sancion.getExpediente().getProcedimiento().getDescripcionEs() != null) {
						cabeceraSancionProcedimiento = sancion.getExpediente().getProcedimiento().getDescripcionEs();
					}
				} else {
					if (sancion.getExpediente().getProcedimiento() != null
							&& sancion.getExpediente().getProcedimiento().getDescripcionEu() != null) {
						cabeceraSancionProcedimiento = sancion.getExpediente().getProcedimiento().getDescripcionEu();
					}
				}
			}

			model.addAttribute("cabeceraSancionExpediente", folderNumber);
			model.addAttribute("cabeceraSancionTitulo", titulo);
			model.addAttribute("cabeceraSancionProcedimiento", cabeceraSancionProcedimiento);

			model.addAttribute("idSancion", idSancion);
			if (sancion.getExpediente() != null) {
				model.addAttribute("idExpediente", sancion.getExpediente().getIdExpediente());
				model.addAttribute("folderId", sancion.getExpediente().getFolderId());
				if (sancion.getExpediente().getProcedimiento() != null) {
					model.addAttribute("idProcedimiento",
							sancion.getExpediente().getProcedimiento().getIdProcedimiento());
					model.addAttribute("codProcedureId",
							sancion.getExpediente().getProcedimiento().getCodProcedureId());
				}
			}

			String url = UtilsConfig.getAppProperties().getProperty("urlVerDocumento");
			url = url.replace("[folderID]", sancion.getExpediente().getFolderId());
			model.addAttribute("urlVerDocumentos", url);
			model.addAttribute("urlab63", UtilsConfig.getAppProperties().getProperty("URLAB63"));

			RelSanProSan relSanProSan = new RelSanProSan();
			relSanProSan.setSancion(sancion);
			Long propuestasAsociadas = this.relSanProSanService.findAllCount(relSanProSan);
			model.addAttribute("propuestasAsociadas", propuestasAsociadas);
			model.addAttribute("irAExpediente", irAExpediente);

			boolean esExpedienteCerrado = this.expedienteService.findExpedienteCerrado(sancion.getExpediente());
			model.addAttribute("esExpedienteCerrado", esExpedienteCerrado);

			Document documet = UtilsXlnets.getInstance().getTokenAplicacionDocument();
			SeguridadAplicacion.getRolesUsuario(SecurityContextHolder.getContext().getAuthentication());
			perfilService.getPerfilPuesto(usuario.getUsuario(), StaticsContainer.webAppName);
			
			
			
			return "fichaSancion";
		} else {
			return "folderError";
		}
	}

}
