package com.ejie.ab59.service.propuestasSancion;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab59.dao.propuestasSancion.RelProSanFecDao;
import com.ejie.ab59.model.propuestasSancion.RelProSanFec;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

@Service(value = "relProSanFecService")
public class RelProSanFecServiceImpl implements RelProSanFecService {

	@Autowired
	private RelProSanFecDao relProSanFecDao;

	/**
	 * Inserts a single row in the RelProSanFec table.
	 *
	 * @param relProSanFec
	 *            RelProSanFec
	 * 
	 * @return RelProSanFec
	 */
	public RelProSanFec add(RelProSanFec relProSanFec) {
		return this.relProSanFecDao.add(relProSanFec);
	}

	@Override
	public TableResponseDto<RelProSanFec> filterHistorialFechas(RelProSanFec filterRelProSanFec,
			TableRequestDto tableRequestDto) {
		List<RelProSanFec> listaRelProSanFec = this.relProSanFecDao.findAllLike(filterRelProSanFec, tableRequestDto);
		Long recordNum = this.relProSanFecDao
				.findAllLikeCount(filterRelProSanFec != null ? filterRelProSanFec : new RelProSanFec());

		return new TableResponseDto<RelProSanFec>(tableRequestDto, recordNum, listaRelProSanFec);
	}

	@Override
	public void removeByPropuestaSancion(Integer idPropuestaSancion) {
		this.relProSanFecDao.removeByPropuestaSancion(idPropuestaSancion);
	}

}
