package com.ejie.ab59.service.propuestasSancion;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.propuestasSancion.RelArtInfProSanDao;
import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.propuestasSancion.RelArtInfProSan;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * ArtInfProSanServiceImpl  
 * 
 *  
 */

@Service(value = "artInfProSanService")
public class RelArtInfProSanServiceImpl implements RelArtInfProSanService {

	@Autowired
	private RelArtInfProSanDao relArtInfProSanDao;

	/**
	 * Inserts a single row in the ArtInfProSan table.
	 *
	 * @param artInfProSan
	 *            ArtInfProSan
	 * @return ArtInfProSan
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RelArtInfProSan add(RelArtInfProSan artInfProSan) {
		return this.relArtInfProSanDao.add(artInfProSan);
	}

	/**
	 * Updates a single row in the ArtInfProSan table.
	 *
	 * @param artInfProSan
	 *            ArtInfProSan
	 * @return ArtInfProSan
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RelArtInfProSan update(RelArtInfProSan artInfProSan) {
		return this.relArtInfProSanDao.update(artInfProSan);
	}

	/**
	 * Finds a single row in the ArtInfProSan table.
	 *
	 * @param artInfProSan
	 *            ArtInfProSan
	 * @return ArtInfProSan
	 */
	public RelArtInfProSan find(RelArtInfProSan artInfProSan) {
		return this.relArtInfProSanDao.find(artInfProSan);
	}

	/**
	 * Deletes a single row in the ArtInfProSan table.
	 *
	 * @param artInfProSan
	 *            ArtInfProSan
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RelArtInfProSan artInfProSan) {
		this.relArtInfProSanDao.remove(artInfProSan);
	}

	/**
	 * Finds a list of rows in the ArtInfProSan table.
	 *
	 * @param artInfProSan
	 *            ArtInfProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<ArtInfProSan>
	 */
	public List<RelArtInfProSan> findAll(RelArtInfProSan artInfProSan, TableRequestDto tableRequestDto) {
		return (List<RelArtInfProSan>) this.relArtInfProSanDao.findAll(artInfProSan, tableRequestDto);
	}

	/**
	 * Filter method in the ArtInfProSan table.
	 *
	 * @param filterArtInfProSan
	 *            ArtInfProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<ArtInfProSan>
	 */
	public TableResponseDto<RelArtInfProSan> filter(RelArtInfProSan filterArtInfProSan,
			TableRequestDto tableRequestDto) {
		List<RelArtInfProSan> listaArtInfProSan = this.relArtInfProSanDao.findAll(filterArtInfProSan, tableRequestDto);
		Long recordNum = this.relArtInfProSanDao
				.findAllCount(filterArtInfProSan != null ? filterArtInfProSan : new RelArtInfProSan());

		return new TableResponseDto<RelArtInfProSan>(tableRequestDto, recordNum, listaArtInfProSan);
	}

	/**
	 * Removes a single row in the ArtInfProSan table.
	 *
	 * @param idPropuestaSancion
	 *            Integer
	 * @return
	 */
	public void removeByPropuestaSancion(Integer idPropuestaSancion) {
		this.relArtInfProSanDao.removeByPropuestaSancion(idPropuestaSancion);
	}

	/**
	 * Filter method in the RelArtInfProSan table.
	 *
	 * @param filterRelArtInfProSan
	 *            RelArtInfProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<RelArtInfProSan>
	 */
	public TableResponseDto<RelArtInfProSan> filterControlFechas(RelArtInfProSan filterRelArtInfProSan,
			TableRequestDto tableRequestDto) {

		List<RelArtInfProSan> listaPropuestasSancion = this.relArtInfProSanDao.findControlFechas(filterRelArtInfProSan,
				tableRequestDto);
		Long recordNum = this.relArtInfProSanDao
				.findControlFechasCount(filterRelArtInfProSan != null ? filterRelArtInfProSan : new RelArtInfProSan());

		return new TableResponseDto<RelArtInfProSan>(tableRequestDto, recordNum, listaPropuestasSancion);
	}

	@Override
	public RelArtInfProSan findFechaHechoMasAntigua(PropuestasSancion propuestaSancion) {
		return this.relArtInfProSanDao.findFechaHechoMasAntigua(propuestaSancion);
	}
}
