package com.ejie.ab59.service.propuestasSancion;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.propuestasSancion.RelArtInfProSanDerDao;
import com.ejie.ab59.model.propuestasSancion.RelArtInfProSanDer;

/**
 * 
 *  
 *
 */

@Service(value = "relArtInfProSanDerService")
public class RelArtInfProSanDerServiceImpl implements RelArtInfProSanDerService {

	@Autowired
	private RelArtInfProSanDerDao relArtInfProSanDerDao;

	/**
	 * Inserts a single row in the RelArtInfProSanDer table.
	 *
	 * @param derechoInfringido
	 *            RelArtInfProSanDer
	 * @return RelArtInfProSanDer
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RelArtInfProSanDer add(RelArtInfProSanDer derechoInfringido) {
		return this.relArtInfProSanDerDao.add(derechoInfringido);
	}

	/**
	 * Removes a single row in the RelArtInfProSanDer table.
	 *
	 * @param idPropuestaSancion
	 *            Integer
	 * @return
	 */
	public void removeByPropuestaSancion(Integer idPropuestaSancion) {
		this.relArtInfProSanDerDao.removeByPropuestaSancion(idPropuestaSancion);
	}
}
