package com.ejie.ab59.service.propuestasSancion;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;

import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.AlcanceResolucion;
import com.ejie.ab59.clientesWS.ab61WebService.DatosInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosLlamadaConsultaDatosInteresado;
import com.ejie.ab59.clientesWS.ab61WebService.DatosLlamadaGenerarExpedienteInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosRespuestaConsultaDatosInteresado;
import com.ejie.ab59.clientesWS.ab61WebService.Denuncia;
import com.ejie.ab59.clientesWS.ab61WebService.EmisorInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.InicioOficioSancionesWS;
import com.ejie.ab59.clientesWS.ab61WebService.Prescripcion;
import com.ejie.ab59.clientesWS.ab61WebService.Resolucion;
import com.ejie.ab59.clientesWS.ab61WebService.Tablon;
import com.ejie.ab59.clientesWS.ab61WebService.TipoAlcanceResolucion;
import com.ejie.ab59.clientesWS.ab61WebService.TipoBooleano;
import com.ejie.ab59.clientesWS.ab61WebService.TipoDocumentoIdentidad;
import com.ejie.ab59.clientesWS.ab61WebService.TipoPlazo;
import com.ejie.ab59.clientesWS.ab61WebService.TipoPublicacionTablon;
import com.ejie.ab59.clientesWS.ab61WebService.TipoRedaccionTablon;
import com.ejie.ab59.clientesWS.ab61WebService.TipoSancion;
import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.dao.procedimientos.ProcedimientosDao;
import com.ejie.ab59.dao.propuestasSancion.PropuestasSancionDao;
import com.ejie.ab59.dao.propuestasSancion.RelArtInfProSanDao;
import com.ejie.ab59.dao.propuestasSancion.RelProSanFecDao;
import com.ejie.ab59.dao.propuestasSancion.RelProSanSanDao;
import com.ejie.ab59.dao.tablasMaestras.CalificacionesDao;
import com.ejie.ab59.dao.tablasMaestras.ConfIniOfiDao;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.propuestasSancion.RelArtInfProSan;
import com.ejie.ab59.model.propuestasSancion.RelProSanFec;
import com.ejie.ab59.model.propuestasSancion.RelProSanSan;
import com.ejie.ab59.model.sanciones.RelSanProSan;
import com.ejie.ab59.model.tablasMaestras.Calificaciones;
import com.ejie.ab59.model.tablasMaestras.ConfIniOfi;
import com.ejie.ab59.webservice.adaptadores.ab61WebServiceAdaptador;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * PropuestasSancionServiceImpl  
 * 
 *  
 */

@Service(value = "propuestasSancionService")
public class PropuestasSancionServiceImpl implements PropuestasSancionService {

	private static final Logger logger = LoggerFactory.getLogger(PropuestasSancionServiceImpl.class);

	@Autowired
	private PropuestasSancionDao propuestasSancionDao;
	@Autowired
	private RelProSanSanDao relProSanSanDao;
	@Autowired
	private RelProSanFecDao relProSanFecDao;
	@Autowired
	private ProcedimientosDao procedimientosDao;
	@Autowired
	private ConfIniOfiDao confIniOfiDao;
	@Autowired
	private RelArtInfProSanDao relArtInfProSanDao;
	@Autowired
	private CalificacionesDao calificacionesDao;
	@Autowired
	private ab61WebServiceAdaptador ab61WebServiceAdaptadorService;

	@Resource
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the PropuestasSancion table.
	 *
	 * @param propuestasSancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PropuestasSancion add(PropuestasSancion propuestasSancion) {
		return this.propuestasSancionDao.add(propuestasSancion);
	}

	/**
	 * Updates a single row in the PropuestasSancion table.
	 *
	 * @param propuestasSancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PropuestasSancion update(PropuestasSancion propuestasSancion) {

		/* Actualizar REL_PRO_SAN_SAN (AB6128T00) */
		RelProSanSan relProSanSan = new RelProSanSan();
		relProSanSan.setPropuestaSancion(propuestasSancion);
		relProSanSan.setEstado(propuestasSancion.getEstado());
		relProSanSan.setUsuarioUltModificacion(propuestasSancion.getUsuarioUltmodificacion());
		this.relProSanSanDao.updateByPropuestaSancion(relProSanSan);

		/* Actualizar PROPUESTAS_SANCION (AB5902T00) */
		PropuestasSancion propuestaSancionAux = this.propuestasSancionDao.update(propuestasSancion);

		/* Insertar REL_PRO_SAN_FEC (AB5919T00) */
		RelProSanFec relProSanFec = new RelProSanFec();
		relProSanFec.setIdPropuestaSancion(propuestasSancion.getIdPropuestaSancion());
		relProSanFec.setUsuarioRegistro(propuestasSancion.getUsuarioUltmodificacion());
		if (propuestasSancion.getEstado() != null) {
			switch (propuestasSancion.getEstado()) {
			case Constantes.ESTADO_RECHAZO:
				relProSanFec.setTipoFecha(Constantes.FECHA_RECHAZO);
				break;
			case Constantes.ESTADO_REQUERIMIENTO_SUBSANACION:
				relProSanFec.setTipoFecha(Constantes.FECHA_REQUERIMIENTO_SUBSANACION);
				break;
			case Constantes.ESTADO_VALIDADA_DIRECCION_TURISMO:
				relProSanFec.setTipoFecha(Constantes.FECHA_VALIDACION_DIRECCION);
				break;

			default:
				break;
			}
		}
		this.relProSanFecDao.add(relProSanFec);

		return propuestaSancionAux;
	}

	/**
	 * Finds a single row in the PropuestasSancion table.
	 *
	 * @param propuestasSancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	public PropuestasSancion find(PropuestasSancion propuestasSancion) {
		return this.propuestasSancionDao.find(propuestasSancion);
	}

	@Override
	public PropuestasSancion findByAnio(String anio) {
		return this.propuestasSancionDao.findByAnio(anio);
	}

	@Override
	public PropuestasSancion findSinExpediente(PropuestasSancion propuestaSancion) {
		return this.propuestasSancionDao.findSinExpediente(propuestaSancion);
	}

	/**
	 * Deletes a single row in the PropuestasSancion table.
	 *
	 * @param propuestasSancion
	 *            PropuestasSancion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(PropuestasSancion propuestasSancion) {
		this.propuestasSancionDao.remove(propuestasSancion);
	}

	/**
	 * Metodo que comprueba si una propuesta de sanción tiene identidicador de
	 * establecimiento indicado.
	 *
	 * @param relSanProSan
	 *            RelSanProSan Bean que contiene la informacion con la que se va
	 *            a crear el nuevo registro.
	 * @return RelSanProSan Bean resultante del proceso de creacion.
	 */
	@Transactional(rollbackFor = Throwable.class)
	public boolean comprobarEstablecimientoPropuesta(PropuestasSancion propuestasSancion) {

		// Buscamos los datos de la propuesta de sancion
		PropuestasSancion datosPropuestasSancion = this.find(propuestasSancion);

		if (datosPropuestasSancion == null || datosPropuestasSancion.getDatosDirecciones() == null) {
			datosPropuestasSancion = this.findSinExpediente(propuestasSancion);
		}

		if (datosPropuestasSancion.getDatosDirecciones() != null) {
			if (datosPropuestasSancion.getDatosDirecciones().getIdentificadorEstablecimiento().equals("")
					|| datosPropuestasSancion.getDatosDirecciones().getIdentificadorEstablecimiento() == null) {
				return false;
			} else {
				return true;
			}
		} else {
			return false;
		}

	}

	/**
	 * Finds a list of rows in the PropuestasSancion table.
	 *
	 * @param propuestasSancion
	 *            PropuestasSancion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<PropuestasSancion>
	 */
	public List<PropuestasSancion> findAll(PropuestasSancion propuestasSancion, TableRequestDto tableRequestDto) {
		return this.propuestasSancionDao.findAll(propuestasSancion, tableRequestDto);
	}

	/**
	 * Filter method in the PropuestasSancion table.
	 *
	 * @param filterPropuestasSancion
	 *            PropuestasSancion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<PropuestasSancion>
	 */
	public TableResponseDto<PropuestasSancion> filter(PropuestasSancion filterPropuestasSancion,
			TableRequestDto tableRequestDto) {
		this.fncReordenarSentencia(tableRequestDto);

		List<PropuestasSancion> listaPropuestasSancion = this.propuestasSancionDao.findAll(filterPropuestasSancion,
				tableRequestDto);
		Long recordNum = this.propuestasSancionDao
				.findAllCount(filterPropuestasSancion != null ? filterPropuestasSancion : new PropuestasSancion());

		return new TableResponseDto<PropuestasSancion>(tableRequestDto, recordNum, listaPropuestasSancion);
	}

	/**
	 * Transformar los campos del ORDER BY cuando están dentro de un objeto
	 * 
	 * @param tableRequestDto
	 *            TableRequestDto
	 */
	private void fncReordenarSentencia(TableRequestDto tableRequestDto) {

		if (tableRequestDto != null && tableRequestDto.getSidx() != null
				&& tableRequestDto.getSidx().equals("NOMBRETITULAR")) {
			tableRequestDto.setSidx("NOMBRETITULAR " + tableRequestDto.getSord() + ", APELLIDO1TITULAR "
					+ tableRequestDto.getSord() + ", APELLIDO2TITULAR");
		} else if (tableRequestDto != null && tableRequestDto.getSidx() != null
				&& tableRequestDto.getSidx().equals("UBICACIONESTABLECIMIENTO")) {
			tableRequestDto.setSidx("DIRECCION " + tableRequestDto.getSord() + ", NUMERO " + tableRequestDto.getSord()
					+ ", ESCALERA " + tableRequestDto.getSord() + ", PISO " + tableRequestDto.getSord() + ", LETRA");
		} else if (tableRequestDto != null && tableRequestDto.getSidx() != null
				&& tableRequestDto.getSidx().equals("CALIFICACIONCASTELLANO")) {
			tableRequestDto.setSidx("DESCCALIFICACIONCAST");
		} else if (tableRequestDto != null && tableRequestDto.getSidx() != null
				&& tableRequestDto.getSidx().equals("CALIFICACIONEUSKERA")) {
			tableRequestDto.setSidx("DESCCALIFICACIONEUS");
		}
	}

	@Override
	public void getExcel(List<PropuestasSancion> propuestasSancion, HttpServletResponse response) {

		Locale locale = LocaleContextHolder.getLocale();

		try {

			// Nombre del archivo
			String fileName = appMessageSource.getMessage("excel.propuestasSancion.sheetName", null, locale) + ".xls";

			// Creamos la hoja
			HSSFWorkbook workbook = new HSSFWorkbook();
			HSSFSheet sheet = workbook
					.createSheet(appMessageSource.getMessage("excel.propuestasSancion.sheetName", null, locale));

			// Definimos los estilos y fuentes de la hoja
			HSSFFont font = workbook.createFont();
			font.setFontName(HSSFFont.FONT_ARIAL);
			font.setFontHeightInPoints((short) 12);
			font.setBoldweight(Font.BOLDWEIGHT_BOLD);

			HSSFCellStyle headerStyle = workbook.createCellStyle();
			headerStyle.setBorderBottom(CellStyle.BORDER_MEDIUM);
			headerStyle.setFont(font);
			headerStyle.setAlignment(CellStyle.ALIGN_CENTER);

			HSSFCellStyle disabledStyle = workbook.createCellStyle();
			disabledStyle.setFillPattern(CellStyle.THIN_FORWARD_DIAG);

			// Creamos la fila cabecera
			HSSFRow rowHead = sheet.createRow(0);

			rowHead.createCell(0).setCellValue(
					appMessageSource.getMessage("excel.propuestasSancion.identificadorProSan", null, locale));
			rowHead.createCell(1)
					.setCellValue(appMessageSource.getMessage("excel.propuestasSancion.numExpediente", null, locale));
			rowHead.createCell(2).setCellValue(
					appMessageSource.getMessage("excel.propuestasSancion.tituloExpediente", null, locale));
			rowHead.createCell(3).setCellValue(
					appMessageSource.getMessage("excel.propuestasSancion.identificadorInspeccion", null, locale));
			rowHead.createCell(4).setCellValue(
					appMessageSource.getMessage("excel.propuestasSancion.ubicacionEstablecimiento", null, locale));
			rowHead.createCell(5).setCellValue(
					appMessageSource.getMessage("excel.propuestasSancion.municipioLocalidad", null, locale));
			rowHead.createCell(6).setCellValue(
					appMessageSource.getMessage("excel.propuestasSancion.notasInternasResponsable", null, locale));
			rowHead.createCell(7).setCellValue(
					appMessageSource.getMessage("excel.propuestasSancion.expedienteSancionador", null, locale));

			rowHead.getCell(0).setCellStyle(headerStyle);
			rowHead.getCell(1).setCellStyle(headerStyle);
			rowHead.getCell(2).setCellStyle(headerStyle);
			rowHead.getCell(3).setCellStyle(headerStyle);
			rowHead.getCell(4).setCellStyle(headerStyle);
			rowHead.getCell(5).setCellStyle(headerStyle);
			rowHead.getCell(6).setCellStyle(headerStyle);
			rowHead.getCell(7).setCellStyle(headerStyle);

			// Creamos el resto de filas con sus celdas
			int rowCount = 1;
			for (PropuestasSancion propuestaSancion : propuestasSancion) {

				HSSFRow propuestaSancionRow = sheet.createRow(rowCount++);

				if (propuestaSancion != null) {
					propuestaSancionRow.createCell(0).setCellValue(propuestaSancion.getIdentificadorProSan());
					if (propuestaSancion.getExpedienteOrigen() != null) {
						propuestaSancionRow.createCell(1)
								.setCellValue(propuestaSancion.getExpedienteOrigen().getFolderNumber());
						propuestaSancionRow.createCell(2)
								.setCellValue(propuestaSancion.getExpedienteOrigen().getTitulo());
					}
					propuestaSancionRow.createCell(3).setCellValue(propuestaSancion.getIdentificadorInspeccion());
					if (propuestaSancion.getExpedienteOrigen() != null
							&& propuestaSancion.getExpedienteOrigen().getDatosDirecciones() != null) {
						propuestaSancionRow.createCell(4).setCellValue(propuestaSancion.getExpedienteOrigen()
								.getDatosDirecciones().getUbicacionEstablecimiento());
						propuestaSancionRow.createCell(5).setCellValue(
								propuestaSancion.getExpedienteOrigen().getDatosDirecciones().getMunicipioLocalidad());
					}
					propuestaSancionRow.createCell(6).setCellValue(propuestaSancion.getNotasRespOfi());
					propuestaSancionRow.createCell(7)
							.setCellValue(propuestaSancion.getExpedienteSancionador().getFolderNumber());
				}
			}

			// Anchura de las columnas
			sheet.autoSizeColumn(0);
			sheet.autoSizeColumn(1);
			sheet.autoSizeColumn(2);
			sheet.autoSizeColumn(3);
			sheet.autoSizeColumn(4);
			sheet.autoSizeColumn(5);
			sheet.autoSizeColumn(6);
			sheet.autoSizeColumn(7);

			FileOutputStream fileOut = new FileOutputStream(fileName);
			workbook.write(fileOut);
			fileOut.close();

			PropuestasSancionServiceImpl.logger.info("[GET - exportarExcel] : Archivo generado");

			// Creamos el archivo a descargar
			File fileToDownload = new File(fileName);
			InputStream in = new FileInputStream(fileToDownload);

			// Recogemos el MIME type del fichero
			String mimeType = new MimetypesFileTypeMap().getContentType(fileName);

			if (mimeType == null) {
				// Si no se encuentra lo seteamos manualmente
				mimeType = "application/octet-stream";
			}
			PropuestasSancionServiceImpl.logger.info("[GET - exportarExcel] : MIME type: " + mimeType);

			// Seteamos el contentType de la response
			response.setContentType(mimeType);
			response.setContentLength((int) fileToDownload.length());

			// Descargamos el archivo
			response.setHeader("Content-Disposition", "attachment; filename=\"" + fileToDownload.getName() + "\"");

			// Obtenemos el outputStream de la response
			OutputStream outStream = response.getOutputStream();

			byte[] buffer = new byte[4096];
			int bytesRead = -1;

			while ((bytesRead = in.read(buffer)) != -1) {
				outStream.write(buffer, 0, bytesRead);
			}

			// Cerramos el InputStream y el OutputStream
			in.close();
			outStream.close();

			PropuestasSancionServiceImpl.logger.info("[GET - exportarExcel] : Archivo descargado con éxito");

		} catch (Exception e) {
			PropuestasSancionServiceImpl.logger.error(e.getMessage());
		}
	}

	/**
	 * Counts rows in the PropuestasSancion table.
	 *
	 * @param idPropuestasSancion
	 *            Integer
	 * 
	 * @return Long
	 */
	public Long validarEstadoValidadaOSancionador(Integer idPropuestasSancion) {
		return this.propuestasSancionDao.validarEstadoValidadaOSancionador(idPropuestasSancion);
	}

	/**
	 * Counts rows in the PropuestasSancion table.
	 *
	 * @param idPropuestasSancion
	 *            Integer
	 * 
	 * @return Long
	 */
	public Long validarExistePropuesta(Integer idPropuestasSancion) {
		return this.propuestasSancionDao.validarExistePropuesta(idPropuestasSancion);
	}

	/**
	 * Updates a single row in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * 
	 * @return PropuestasSancion
	 */
	public PropuestasSancion updatePropuestaSancion(PropuestasSancion propuestassancion) {
		return this.propuestasSancionDao.updatePropuestaSancion(propuestassancion);
	}

	@Override
	public RelSanProSan obtenerCabeceraPropuestaSancion(Integer idPropuestaSancion) {
		return this.propuestasSancionDao.obtenerCabeceraPropuestaSancion(idPropuestaSancion);
	}

	@Override
	public PropuestasSancion updateEstadoProSan(PropuestasSancion propuestaSancion) {
		return this.propuestasSancionDao.updateEstadoProSan(propuestaSancion);
	}

	@Override
	public PropuestasSancion updateFolderIdEstado(PropuestasSancion propuestaSancion) {
		return this.propuestasSancionDao.updateFolderIdEstado(propuestaSancion);
	}

	@Override
	public Date findFechaAperturaMasActual(Integer idExpediente) {
		return this.propuestasSancionDao.findFechaAperturaMasActual(idExpediente);
	}

	@Override
	public SqlRowSet findPropuestasPendientesMismoTitular(Integer idPropuestaSancion) {
		return this.propuestasSancionDao.findPropuestasPendientesMismoTitular(idPropuestaSancion);
	}

	@Override
	public SqlRowSet findPropuestasPendientesMismoTitularBySancion(Integer idSancion) {
		return this.propuestasSancionDao.findPropuestasPendientesMismoTitularBySancion(idSancion);
	}

	@Override
	public List<DatosRespuestaConsultaDatosInteresado> consultaDatosInteresado(Integer idProcedimiento,
			List<Integer> listaIdTerceros) {

		PropuestasSancionServiceImpl.logger.info("INICIO [consultaDatosInteresado]");
		Procedimientos procedimiento = this.procedimientosDao.find(new Procedimientos(idProcedimiento));

		PropuestasSancionServiceImpl.logger
				.info("INICIO [consultaDatosInteresado] :: Asignamos los datos necesarios para la consulta");
		DatosLlamadaConsultaDatosInteresado elementoEnviar = new DatosLlamadaConsultaDatosInteresado();
		elementoEnviar.setProcedureId(procedimiento.getCodProcedureId());
		for (int i = 0; i < listaIdTerceros.size(); i++) {

			elementoEnviar.getListaTerceros().add(listaIdTerceros.get(i));
		}

		List<DatosRespuestaConsultaDatosInteresado> retornoPantalla = new java.util.ArrayList<DatosRespuestaConsultaDatosInteresado>();
		try {

			PropuestasSancionServiceImpl.logger.info(
					"INICIO [consultaDatosInteresado] :: Llamada al servicio web para obtener los datos del interesado");
			retornoPantalla = ab61WebServiceAdaptadorService.obtenerDatosInteresado(elementoEnviar);
		} catch (Ab61Exception e) {
			PropuestasSancionServiceImpl.logger.error("Excepcion obtenida ", e);
		}

		PropuestasSancionServiceImpl.logger.info("FIN [consultaDatosInteresado]");
		return retornoPantalla;
	}

	@Override
	public DatosInicioOficio crearExpedienteSancionadorInicioOficio(Integer idPropuestaSancion, Integer idProcedimiento,
			Usuario usuario, DatosLlamadaGenerarExpedienteInicioOficio datosLlamada) throws Ab61Exception, Exception {

		PropuestasSancionServiceImpl.logger.info("INICIO [crearExpedienteSancionadorInicioOficio]");

		GregorianCalendar gregory = new GregorianCalendar();
		DatosInicioOficio datosInicioOficio = new DatosInicioOficio();

		try {

			PropuestasSancionServiceImpl.logger
					.info("[crearExpedienteSancionadorInicioOficio] :: Se lee el procedimiento");
			Procedimientos procedimiento = new Procedimientos();
			procedimiento.setIdProcedimiento(idProcedimiento);
			procedimiento = this.procedimientosDao.find(procedimiento);

			PropuestasSancionServiceImpl.logger
					.info("[crearExpedienteSancionadorInicioOficio] :: Se lee la propuesta de sancion");
			PropuestasSancion propuestaSancion = new PropuestasSancion();
			propuestaSancion.setIdPropuestaSancion(idPropuestaSancion);
			propuestaSancion = this.propuestasSancionDao.find(propuestaSancion);

			PropuestasSancionServiceImpl.logger
					.info("[crearExpedienteSancionadorInicioOficio] :: Se obtiene RelArtInfProSan");
			RelArtInfProSan relArtInfProSan = this.relArtInfProSanDao.findFechaHechoMasAntigua(propuestaSancion);

			PropuestasSancionServiceImpl.logger
					.info("[crearExpedienteSancionadorInicioOficio] :: Se obtiene ConfIniOfi");
			ConfIniOfi configuracion = this.confIniOfiDao.findByProcedimiento(procedimiento);

			PropuestasSancionServiceImpl.logger
					.info("[crearExpedienteSancionadorInicioOficio] :: Se obtiene Calificaciones");
			Calificaciones calificacion = this.calificacionesDao.findMasGraveDePropuestaSancion(propuestaSancion);

			if (calificacion != null) {

				if (!"".equals(calificacion.getDescripcionCastellano())) {

					if (calificacion.getDescripcionCastellano().equals(TipoSancion.LEVE.toString())) {
						datosLlamada.setTipoSancion(TipoSancion.LEVE);
					} else if (calificacion.getDescripcionCastellano().equals(TipoSancion.GRAVE.toString())) {
						datosLlamada.setTipoSancion(TipoSancion.GRAVE);
					} else if (calificacion.getDescripcionCastellano().equals(TipoSancion.MUY_GRAVE.toString())) {
						datosLlamada.setTipoSancion(TipoSancion.MUY_GRAVE);
					} else if (calificacion.getDescripcionCastellano().equals(TipoSancion.MENOS_GRAVE.toString())) {
						datosLlamada.setTipoSancion(TipoSancion.MENOS_GRAVE);
					}

				}

				if (calificacion.getPlazo() != null) {
					Prescripcion prescripcion = new Prescripcion();
					prescripcion.setPlazoPrescripcion(String.valueOf(calificacion.getPlazo()));
					prescripcion.setTipoPlazoPrescripcion(TipoPlazo.ANIO);
					datosLlamada.setPrescripcion(prescripcion);
				}

			}

			if (relArtInfProSan != null) {
				gregory.setTime(relArtInfProSan.getFechaHecho());
				XMLGregorianCalendar fechaInfraccionCal = DatatypeFactory.newInstance()
						.newXMLGregorianCalendar(gregory);
				datosLlamada.setFechaInfraccion(fechaInfraccionCal);
			}

			PropuestasSancionServiceImpl.logger
					.info("[crearExpedienteSancionadorInicioOficio] :: Se genera la denuncia");
			Denuncia denuncia = new Denuncia();
			if (Constantes.ORIGEN_DENUNCIAS.equals(propuestaSancion.getIdOrigenProSancion())) {
				denuncia.setExisteDenuncia(TipoBooleano.TRUE);
				denuncia.setCodigoExpDenuncia(propuestaSancion.getExpedienteOrigen().getFolderNumber());
			} else {
				denuncia.setExisteDenuncia(TipoBooleano.FALSE);
			}

			PropuestasSancionServiceImpl.logger
					.info("[crearExpedienteSancionadorInicioOficio] :: Se genera el EmisorInicioOficio");
			EmisorInicioOficio emisorInicioOficio = new EmisorInicioOficio();
			emisorInicioOficio.setIdEmsisor(usuario.getIdentificador());
			emisorInicioOficio.setTipoDocumentoIdentidad(TipoDocumentoIdentidad.NIF);
			emisorInicioOficio.setNombreEmisor(usuario.getNombreUsuario());
			emisorInicioOficio.setPrimerApellido(usuario.getPrimerApellido());
			emisorInicioOficio.setSegundoApellido(usuario.getSegundoApellido());

			List<String> listaTiposAlcanceResolucion = this.confIniOfiDao.findTiposAlcanceResolucion(procedimiento);
			for (String tipoAlcanceResolucionStr : listaTiposAlcanceResolucion) {

				AlcanceResolucion alcanceResolucion = new AlcanceResolucion();

				if (tipoAlcanceResolucionStr.equalsIgnoreCase(TipoAlcanceResolucion.DECOMISO.toString())) {
					alcanceResolucion.setAlcanceResolucion(TipoAlcanceResolucion.DECOMISO);
					datosLlamada.getListaAlcanceResolucion().add(alcanceResolucion);
				} else if (tipoAlcanceResolucionStr.equalsIgnoreCase(TipoAlcanceResolucion.INDEMNIZACION.toString())) {
					alcanceResolucion.setAlcanceResolucion(TipoAlcanceResolucion.INDEMNIZACION);
					datosLlamada.getListaAlcanceResolucion().add(alcanceResolucion);
				} else if (tipoAlcanceResolucionStr
						.equalsIgnoreCase(TipoAlcanceResolucion.REPOSICION_DANO.toString())) {
					alcanceResolucion.setAlcanceResolucion(TipoAlcanceResolucion.REPOSICION_DANO);
					datosLlamada.getListaAlcanceResolucion().add(alcanceResolucion);
				} else if (tipoAlcanceResolucionStr
						.equalsIgnoreCase(TipoAlcanceResolucion.SANCION_ECONOMICA.toString())) {
					alcanceResolucion.setAlcanceResolucion(TipoAlcanceResolucion.SANCION_ECONOMICA);
					datosLlamada.getListaAlcanceResolucion().add(alcanceResolucion);
				}

			}

			datosLlamada.setEmisorInicioficio(emisorInicioOficio);
			datosLlamada.setDenuncia(denuncia);
			datosLlamada.setProcedureId(procedimiento.getCodProcedureId());
			datosLlamada.setCodigoDepartamentoExp((configuracion != null && configuracion.getCodigoDepExp() != null
					? configuracion.getCodigoDepExp() : null));
			datosLlamada.setBuzonFirmante((configuracion != null && configuracion.getFirmante() != null
					? configuracion.getFirmante().getBuzon() : null));

			PropuestasSancionServiceImpl.logger.info("[crearExpedienteSancionadorInicioOficio] :: Se genera el tablon");
			Tablon tablon = new Tablon();

			if (configuracion != null && configuracion.getPlazotablon() != null) {
				tablon.setPlazoTablon(String.valueOf(configuracion.getPlazotablon()));
			}

			if (configuracion != null && !"".equals(configuracion.getTipoPlazoTablon())
					&& configuracion.getTipoPlazoTablon() != null) {

				if (configuracion.getTipoPlazoTablon().equalsIgnoreCase(TipoPlazo.DIA.toString())) {
					tablon.setTipoPlazoTablon(TipoPlazo.DIA);
				} else if (configuracion.getTipoPlazoTablon().equalsIgnoreCase(TipoPlazo.MES.toString())) {
					tablon.setTipoPlazoTablon(TipoPlazo.MES);
				} else if (configuracion.getTipoPlazoTablon().equalsIgnoreCase(TipoPlazo.TRIMESTRE.toString())) {
					tablon.setTipoPlazoTablon(TipoPlazo.TRIMESTRE);
				} else if (configuracion.getTipoPlazoTablon().equalsIgnoreCase(TipoPlazo.ANIO.toString())) {
					tablon.setTipoPlazoTablon(TipoPlazo.ANIO);
				} else if (configuracion.getTipoPlazoTablon().equalsIgnoreCase(TipoPlazo.DIA_LABORAL.toString())) {
					tablon.setTipoPlazoTablon(TipoPlazo.DIA_LABORAL);
				} else if (configuracion.getTipoPlazoTablon().equalsIgnoreCase(TipoPlazo.FECHA_CONCRETA.toString())) {
					tablon.setTipoPlazoTablon(TipoPlazo.FECHA_CONCRETA);
				}

			}

			if (configuracion != null && configuracion.getPublicarTablon()) {
				tablon.setPublicarTablon(TipoPublicacionTablon.SI);
			} else {
				tablon.setPublicarTablon(TipoPublicacionTablon.NO);
			}

			if (configuracion != null && !"".equals(configuracion.getTipoRedaccionTablon())
					&& configuracion.getTipoRedaccionTablon() != null) {

				if (configuracion.getTipoRedaccionTablon()
						.equalsIgnoreCase(TipoRedaccionTablon.CORREDACCION.toString())) {
					tablon.setTipoRedaccionTablon(TipoRedaccionTablon.CORREDACCION);
				} else if (configuracion.getTipoRedaccionTablon()
						.equalsIgnoreCase(TipoRedaccionTablon.BILINGUE.toString())) {
					tablon.setTipoRedaccionTablon(TipoRedaccionTablon.BILINGUE);
				} else if (configuracion.getTipoRedaccionTablon()
						.equalsIgnoreCase(TipoRedaccionTablon.TRADUCCION.toString())) {
					tablon.setTipoRedaccionTablon(TipoRedaccionTablon.TRADUCCION);
				} else if (configuracion.getTipoRedaccionTablon()
						.equalsIgnoreCase(TipoRedaccionTablon.TRADUCCION_TUTORIZADA.toString())) {
					tablon.setTipoRedaccionTablon(TipoRedaccionTablon.TRADUCCION_TUTORIZADA);
				}

			}
			PropuestasSancionServiceImpl.logger.info("[crearExpedienteSancionadorInicioOficio] :: Tablon asignado");
			datosLlamada.setTablon(tablon);

			PropuestasSancionServiceImpl.logger
					.info("[crearExpedienteSancionadorInicioOficio] :: Se genera la resolucion");
			Resolucion resolucion = new Resolucion();
			if (configuracion != null && configuracion.getPlazoResolucion() != null) {
				resolucion.setPlazoResolucion(String.valueOf(configuracion.getPlazoResolucion()));
			}

			if (configuracion != null && !"".equals(configuracion.getTipoPlazoResolucion())
					&& configuracion.getTipoPlazoResolucion() != null) {

				if (configuracion.getTipoPlazoResolucion().equalsIgnoreCase(TipoPlazo.DIA.toString())) {
					resolucion.setTipoPlazoResolucion(TipoPlazo.DIA);
				} else if (configuracion.getTipoPlazoResolucion().equalsIgnoreCase(TipoPlazo.MES.toString())) {
					resolucion.setTipoPlazoResolucion(TipoPlazo.MES);
				} else if (configuracion.getTipoPlazoResolucion().equalsIgnoreCase(TipoPlazo.TRIMESTRE.toString())) {
					resolucion.setTipoPlazoResolucion(TipoPlazo.TRIMESTRE);
				} else if (configuracion.getTipoPlazoResolucion().equalsIgnoreCase(TipoPlazo.ANIO.toString())) {
					resolucion.setTipoPlazoResolucion(TipoPlazo.ANIO);
				} else if (configuracion.getTipoPlazoResolucion().equalsIgnoreCase(TipoPlazo.DIA_LABORAL.toString())) {
					resolucion.setTipoPlazoResolucion(TipoPlazo.DIA_LABORAL);
				} else if (configuracion.getTipoPlazoResolucion()
						.equalsIgnoreCase(TipoPlazo.FECHA_CONCRETA.toString())) {
					resolucion.setTipoPlazoResolucion(TipoPlazo.FECHA_CONCRETA);
				}

			}

			if (configuracion != null && configuracion.getFechaAcuerdoInicio() != null) {
				gregory.setTime(configuracion.getFechaAcuerdoInicio());
				XMLGregorianCalendar fechaAcuerdoInicioCal = DatatypeFactory.newInstance()
						.newXMLGregorianCalendar(gregory);
				resolucion.setFechaAcuerdoInicio(fechaAcuerdoInicioCal);
			}

			PropuestasSancionServiceImpl.logger.info("[crearExpedienteSancionadorInicioOficio] :: Resolucion asignado");
			datosLlamada.setResolucion(resolucion);

			PropuestasSancionServiceImpl.logger.info(
					"[crearExpedienteSancionadorInicioOficio] :: Llamada a generarExpedienteInicioOficioConDatosInteresado");
			datosInicioOficio = this.ab61WebServiceAdaptadorService
					.generarExpedienteInicioOficioConDatosInteresado(datosLlamada);

		} catch (Ab61Exception ab61) {
			PropuestasSancionServiceImpl.logger
					.error("Ab61Exception [crearExpedienteSancionadorInicioOficio] " + ab61.getMessage(), ab61);
			throw ab61;
		} catch (Exception e) {
			PropuestasSancionServiceImpl.logger
					.error("Exception [crearExpedienteSancionadorInicioOficio] " + e.getMessage(), e);
			throw e;
		}

		PropuestasSancionServiceImpl.logger.info("FIN [crearExpedienteSancionadorInicioOficio]");
		return datosInicioOficio;
	}
}
