package com.ejie.ab59.service.propuestasSancion;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.springframework.jdbc.support.rowset.SqlRowSet;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.DatosInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosLlamadaGenerarExpedienteInicioOficio;
import com.ejie.ab59.clientesWS.ab61WebService.DatosRespuestaConsultaDatosInteresado;
import com.ejie.ab59.clientesWS.ab61WebService.InicioOficioSancionesWS;
import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.model.propuestasSancion.PropuestasSancion;
import com.ejie.ab59.model.sanciones.RelSanProSan;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * PropuestasSancionService  
 * 
 *  
 */

public interface PropuestasSancionService {

	/**
	 * Inserts a single row in the PropuestasSancion table.
	 *
	 * @param propuestasSancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	PropuestasSancion add(PropuestasSancion propuestasSancion);

	/**
	 * Updates a single row in the PropuestasSancion table.
	 *
	 * @param propuestasSancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	PropuestasSancion update(PropuestasSancion propuestasSancion);

	/**
	 * Finds a single row in the PropuestasSancion table.
	 *
	 * @param propuestasSancion
	 *            PropuestasSancion
	 * @return PropuestasSancion
	 */
	PropuestasSancion find(PropuestasSancion propuestasSancion);

	PropuestasSancion findSinExpediente(PropuestasSancion propuestaSancion);

	/**
	 * Deletes a single row in the PropuestasSancion table.
	 *
	 * @param propuestasSancion
	 *            PropuestasSancion
	 */
	void remove(PropuestasSancion propuestasSancion);

	/**
	 * Finds a list of rows in the PropuestasSancion table.
	 *
	 * @param propuestasSancion
	 *            PropuestasSancion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<PropuestasSancion>
	 */
	List<PropuestasSancion> findAll(PropuestasSancion propuestasSancion, TableRequestDto tableRequestDto);

	/**
	 * Filter method in the PropuestasSancion table.
	 *
	 * @param filterPropuestasSancion
	 *            PropuestasSancion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<PropuestasSancion>
	 */
	TableResponseDto<PropuestasSancion> filter(PropuestasSancion filterPropuestasSancion,
			TableRequestDto tableRequestDto);

	void getExcel(List<PropuestasSancion> propuestasSancion, HttpServletResponse response);

	/**
	 * Counts rows in the PropuestasSancion table.
	 *
	 * @param idPropuestasSancion
	 *            Integer
	 * 
	 * @return Long
	 */
	Long validarEstadoValidadaOSancionador(Integer idPropuestasSancion);

	/**
	 * Counts rows in the PropuestasSancion table.
	 *
	 * @param idPropuestasSancion
	 *            Integer
	 * 
	 * @return Long
	 */
	Long validarExistePropuesta(Integer idPropuestasSancion);

	/**
	 * Updates a single row in the PropuestasSancion table.
	 *
	 * @param propuestassancion
	 *            PropuestasSancion
	 * 
	 * @return PropuestasSancion
	 */
	PropuestasSancion updatePropuestaSancion(PropuestasSancion propuestassancion);

	/**
	 * Metodo que comprueba si una propuesta de sanción tiene identidicador de
	 * establecimiento indicado.
	 *
	 * @param propuestasSancion
	 * @return
	 */
	boolean comprobarEstablecimientoPropuesta(PropuestasSancion propuestasSancion);

	RelSanProSan obtenerCabeceraPropuestaSancion(Integer idPropuestaSancion);

	PropuestasSancion updateEstadoProSan(PropuestasSancion propuestaSancion);

	PropuestasSancion updateFolderIdEstado(PropuestasSancion propuestaSancion);

	Date findFechaAperturaMasActual(Integer idExpediente);

	PropuestasSancion findByAnio(String anio);

	/**
	 * Busqueda de propuestas de sancion pendientes de decision o validada por
	 * direccion de un mismo titular
	 */
	SqlRowSet findPropuestasPendientesMismoTitular(Integer idPropuestaSancion);

	SqlRowSet findPropuestasPendientesMismoTitularBySancion(Integer idSancion);

	/**
	 * Consulta de los datos del interesado para despues geenrar el expeidente
	 * de inicio oficio
	 */
	List<DatosRespuestaConsultaDatosInteresado> consultaDatosInteresado(Integer idProcedimiento,
			List<Integer> listaIdTerceros);

	/**
	 * Creacion del expediente de in
	 */
	DatosInicioOficio crearExpedienteSancionadorInicioOficio(Integer idPropuestaSancion, Integer idProcedimiento,
			Usuario usuario, DatosLlamadaGenerarExpedienteInicioOficio datosLlamada) throws Ab61Exception, Exception;
}
