package com.ejie.ab59.service.propuestasSancion;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.SeguridadAplicacion;
import com.ejie.ab59.comun.UtilUsuario;
import com.ejie.ab59.comun.UtilsConfig;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.sanciones.RelSanProSan;
import com.ejie.ab59.service.expedientes.ExpedientesService;
import com.ejie.ab59.service.procedimientos.ProcedimientosService;

/**
 * RelSanProSanServiceImpl  
 * 
 *  
 */

@Service(value = "fichaPropuestaSancionService")
public class FichaPropuestaSancionServiceImpl implements FichaPropuestaSancionService {

	private static final Logger logger = LoggerFactory.getLogger(FichaPropuestaSancionServiceImpl.class);

	@Autowired
	private ExpedientesService expedienteService;

	@Autowired
	private ProcedimientosService procedimientosService;

	@Override
	public String fichaPropuestaSancionView(HttpServletRequest httpRequest, RelSanProSan relSanProSan, Model model) {

		Authentication aut = SecurityContextHolder.getContext().getAuthentication();
		FichaPropuestaSancionServiceImpl.logger.info("autotenticación:getAuthentication" + aut);

		Usuario usuario = UtilUsuario.getUsuario(aut, httpRequest);

		model.addAttribute("usuario", usuario);

		if (relSanProSan != null && relSanProSan.getPropuestaSancion() != null) {
			Integer idPropuestaSancion = relSanProSan.getPropuestaSancion().getIdPropuestaSancion();
			String folderNumber = "";
			String folderId = "";
			String titulo = "";
			String identificadorProSan = "";
			String folderNumberSancionador = "";
			Integer idSancion = null;
			Integer idEstadoProSan = null;
			if (relSanProSan.getPropuestaSancion().getExpedienteOrigen() != null) {
				if (relSanProSan.getPropuestaSancion().getExpedienteOrigen().getFolderNumber() != null) {
					folderNumber = relSanProSan.getPropuestaSancion().getExpedienteOrigen().getFolderNumber();
				}
				if (relSanProSan.getPropuestaSancion().getExpedienteOrigen().getFolderId() != null) {
					folderId = relSanProSan.getPropuestaSancion().getExpedienteOrigen().getFolderId();
				}
				if (relSanProSan.getPropuestaSancion().getExpedienteOrigen().getTitulo() != null) {
					titulo = relSanProSan.getPropuestaSancion().getExpedienteOrigen().getTitulo();
				}
			}
			if (relSanProSan.getPropuestaSancion().getIdentificadorProSan() != null) {
				identificadorProSan = relSanProSan.getPropuestaSancion().getIdentificadorProSan();
			}
			if (relSanProSan.getSancion() != null && relSanProSan.getSancion().getIdSancion() != null) {
				idSancion = relSanProSan.getSancion().getIdSancion();
			}
			if (relSanProSan.getSancion() != null && relSanProSan.getPropuestaSancion().getEstado() != null) {
				idEstadoProSan = relSanProSan.getPropuestaSancion().getEstado();
			}

			if (relSanProSan.getSancion() != null && relSanProSan.getSancion().getExpediente() != null
					&& relSanProSan.getSancion().getExpediente().getIdExpediente() != null) {
				folderNumberSancionador = relSanProSan.getSancion().getExpediente().getFolderNumber();
				model.addAttribute("tieneExpSancionador", true);
			}
			model.addAttribute("cabeceraPropuestaSancionExpedienteSancionador", folderNumberSancionador);
			model.addAttribute("cabeceraPropuestaSancionIdSancion", idSancion);
			model.addAttribute("cabeceraPropuestaSancionExpediente", folderNumber);
			model.addAttribute("cabeceraPropuestaSancionTitulo", titulo);
			model.addAttribute("cabeceraPropuestaSancionIdentificadorProSan", identificadorProSan);
			model.addAttribute("idPropuestaSancion", idPropuestaSancion);
			model.addAttribute("idEstadoProSan", idEstadoProSan);

			String url = UtilsConfig.getAppProperties().getProperty("urlVerDocumento");
			url = url.replace("[folderID]", folderId);
			model.addAttribute("urlVerDocumentos", url);

			boolean esPerfilConsulta = SeguridadAplicacion.esPerfilConsulta();
			model.addAttribute("esPerfilConsulta", esPerfilConsulta);

			if (relSanProSan.getPropuestaSancion().getExpedienteOrigen() != null) {
				model.addAttribute("idExpediente",
						relSanProSan.getPropuestaSancion().getExpedienteOrigen().getIdExpediente());
				model.addAttribute("folderId", relSanProSan.getPropuestaSancion().getExpedienteOrigen().getFolderId());
			}

			boolean esExpedienteCerrado = this.expedienteService
					.findExpedienteCerrado(relSanProSan.getPropuestaSancion().getExpedienteOrigen());
			model.addAttribute("esExpedienteCerrado", esExpedienteCerrado);

			String idDireccion = SeguridadAplicacion.precargarDireccion();
			Procedimientos procedimiento = null;
			String idProcedimiento = "";

			if (!"".contentEquals(idDireccion)) {
				procedimiento = this.procedimientosService.obtenerProcedimientos(Integer.parseInt(idDireccion));
			}

			if (procedimiento != null) {
				idProcedimiento = String.valueOf(procedimiento.getIdProcedimiento());
			}

			model.addAttribute("procedimientoPrecargado", idProcedimiento);

			return "fichaPropuestaSancion";
		} else {
			return "folderError";
		}
	}
}
