package com.ejie.ab59.service.propuestasSancion;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.propuestasSancion.EstadosProSanDao;
import com.ejie.ab59.model.procedimientos.Procedimientos;
import com.ejie.ab59.model.propuestasSancion.EstadosProSan;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * EstadosProSanServiceImpl  
 * 
 *  
 */

@Service(value = "estadosProSanService")
public class EstadosProSanServiceImpl implements EstadosProSanService {

	@Autowired
	private EstadosProSanDao estadosProSanDao;

	@Override
	public List<EstadosProSan> cargarCombo(EstadosProSan estadosProSan) {
		return this.estadosProSanDao.cargarCombo(estadosProSan);
	}

	@Override
	public TableResponseDto<EstadosProSan> filter(EstadosProSan filterEstadosProSan, TableRequestDto tableRequestDto) {

		List<EstadosProSan> listaInfracciones = this.estadosProSanDao.findAll(filterEstadosProSan, tableRequestDto);
		Long recordNum = this.estadosProSanDao
				.findAllCount(filterEstadosProSan != null ? filterEstadosProSan : new EstadosProSan());

		return new TableResponseDto<EstadosProSan>(tableRequestDto, recordNum, listaInfracciones);
	}

	@Transactional(rollbackFor = Throwable.class)
	public EstadosProSan add(EstadosProSan estadoProSan) {
		return this.estadosProSanDao.add(estadoProSan);
	}

	@Transactional(rollbackFor = Throwable.class)
	public EstadosProSan update(EstadosProSan estadoProSan) {
		return this.estadosProSanDao.update(estadoProSan);
	}

	@Transactional(rollbackFor = Throwable.class)
	public void remove(EstadosProSan estadoProSan) {
		this.estadosProSanDao.remove(estadoProSan);
	}

	@Override
	public Integer comprobarPorDefecto(Integer idProcedimiento) {
		return this.estadosProSanDao.comprobarPorDefecto(idProcedimiento);
	}

	@Override
	public EstadosProSan findPorDefecto(Procedimientos procedimiento) {
		return this.estadosProSanDao.findPorDefecto(procedimiento);
	}

	@Override
	public EstadosProSan find(EstadosProSan estadoProSan) {
		return this.estadosProSanDao.find(estadoProSan);
	}

}
