package com.ejie.ab59.service.propuestasSancion;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.DocumentoAportado;
import com.ejie.ab59.clientesWS.ab61WebService.DocumentoWS;
import com.ejie.ab59.clientesWS.ab61WebService.PifException_Exception;
import com.ejie.ab59.clientesWS.ab61WebService.Usuario;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.dao.propuestasSancion.DocProSanDao;
import com.ejie.ab59.model.propuestasSancion.DocProSan;
import com.ejie.ab59.webservice.adaptadores.ab61WebServiceAdaptador;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */

@Service(value = "docProSanService")
public class DocProSanServiceImpl implements DocProSanService {

	public static final Logger logger = LoggerFactory.getLogger(DocProSanServiceImpl.class);

	@Autowired
	private DocProSanDao docProSanDao;
	@Autowired
	private ab61WebServiceAdaptador ab61WebServiceAdaptadorService;

	/**
	 * Inserts a single row in the DocProSan table.
	 *
	 * @param docProSan
	 *            DocProSan
	 * @return DocProSan
	 */
	@Transactional(rollbackFor = Throwable.class)
	public DocProSan add(DocProSan docProSan) {
		return this.docProSanDao.add(docProSan);
	}

	/**
	 * Removes a single row in the ArtInfProSan table.
	 *
	 * @param idPropuestaSancion
	 *            Integer
	 * @return
	 */
	public void removeByPropuestaSancion(Integer idPropuestaSancion) {
		this.docProSanDao.removeByPropuestaSancion(idPropuestaSancion);
	}

	/**
	 * Filter method in the DocProSan table.
	 *
	 * @param filterDocProSan
	 *            DocProSan
	 * @param tableRequestDto
	 *            TableRequestDto
	 * 
	 * @return TableResponseDto<DocProSan>
	 */
	public TableResponseDto<DocProSan> filterByPropuestaSancion(DocProSan filterDocProSan,
			TableRequestDto tableRequestDto) {

		List<DocProSan> listaDocProSan = this.docProSanDao.findByPropuestaSancion(filterDocProSan, tableRequestDto);
		Long recordNum = this.docProSanDao
				.findByPropuestaSancionCount(filterDocProSan != null ? filterDocProSan : new DocProSan());

		return new TableResponseDto<DocProSan>(tableRequestDto, recordNum, listaDocProSan);
	}

	@Transactional
	@Override
	public String aportarDocumentosPlatea(DocProSan docProSan, List<DocumentoWS> documentosWS, String folderId,
			String procedureId, Usuario usuario) throws Ab61Exception {

		DocProSanServiceImpl.logger.info("Entrada a aportarDocumentosPlatea");
		List<DocumentoAportado> documentosAportados = this.ab61WebServiceAdaptadorService
				.aportarDocumentosPlatea(documentosWS, folderId, procedureId, usuario);
		DocProSanServiceImpl.logger.info("Fin aportarDocumentosPlatea");

		DocProSanServiceImpl.logger.info("Actualizamos BBDD");
		// Actualizamos campo aportadoExpediente en AB5915T00
		docProSan.setAportadoExpediente(Constantes.APORTADO_EXPEDIENTE_SI);
		docProSan.setOidDokusi(documentosAportados.get(0).getOidDokusi());
		this.docProSanDao.updateAportadoExpediente(docProSan);

		return "ok";
	}

	@Transactional
	@Override
	public String descargarDocumentoDokusi(String oidDokusi, String aplicacion, Integer tipoUrl)
			throws Ab61Exception, PifException_Exception {

		DocProSanServiceImpl.logger.info("Entrada a descargarDocumentoDokusi");
		return this.ab61WebServiceAdaptadorService.descargarDocumentoDokusi(oidDokusi, aplicacion, tipoUrl);
	}

	@Transactional
	@Override
	public String descargarDocumentoPid(String oidPID, String aplicacion, Integer tipoUrl)
			throws Ab61Exception, PifException_Exception {

		DocProSanServiceImpl.logger.info("Entrada a descargarDocumentoDokusi");
		return this.ab61WebServiceAdaptadorService.descargarDocumentoPid(oidPID, aplicacion, tipoUrl);
	}
}
