package com.ejie.ab59.service.plantillas;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.expedientes.ExpedientesDao;
import com.ejie.ab59.dao.plantillas.RelExpPlaDao;
import com.ejie.ab59.model.plantillas.RelExpPla;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */

@Service(value = "relExpPlaService")
public class RelExpPlaServiceImpl implements RelExpPlaService {

	@Autowired
	private RelExpPlaDao relExpPlaDao;
	@Autowired
	private ExpedientesDao expedientesDao;

	/**
	 * Filter method in the RelExpPla table.
	 *
	 * @param filterRelExpPla
	 *            RelExpPla
	 * @param tableRequestDto
	 *            TableRequestDto
	 * 
	 * @return TableResponseDto<RelExpPla>
	 */
	@Transactional(readOnly = true)
	public TableResponseDto<RelExpPla> filter(RelExpPla filterRelExpPla, TableRequestDto tableRequestDto) {

		List<RelExpPla> listaRelExpPla = this.relExpPlaDao.findAll(filterRelExpPla, tableRequestDto);
		Long recordNum = this.relExpPlaDao.findAllCount(filterRelExpPla != null ? filterRelExpPla : new RelExpPla());

		return new TableResponseDto<RelExpPla>(tableRequestDto, recordNum, listaRelExpPla);
	}
}
