package com.ejie.ab59.service.nora;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab59.dao.nora.T17ProvinciaDao;
import com.ejie.ab59.model.nora.T17Provincia;
import com.ejie.x38.dto.Pagination;

/**
 * T17ProvinciaServiceImpl  
 * 
 *  
 */
@Service(value = "t17ProvinciaService")
public class T17ProvinciaServiceImpl implements T17ProvinciaService {
	
	@Autowired()
	private T17ProvinciaDao t17ProvinciaDao;

	/**
	 * Finds a single row in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @return T17Provincia
	 */
	public T17Provincia find(T17Provincia t17Provincia) {
		return this.t17ProvinciaDao.find(t17Provincia);
	}

	/**
	 * Finds a List of rows in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @param pagination
	 *            Pagination<Object>
	 * @return List
	 */
	public List<T17Provincia> findAll(T17Provincia t17Provincia, Pagination<Object> pagination) {
		return this.t17ProvinciaDao.findAll(t17Provincia, pagination);
	}

	/**
	 * Counts rows in the T17Provincia table.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @return Long
	 */
	public Long findAllCount(T17Provincia t17Provincia) {
		return this.t17ProvinciaDao.findAllCount(t17Provincia);
	}

	/**
	 * Finds rows in the T17Provincia table using like.
	 * 
	 * @param t17Provincia
	 *            T17Provincia
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Provincia>
	 */
	public List<T17Provincia> findAllLike(T17Provincia t17Provincia, Pagination<Object> pagination,
			Boolean startsWith) {
		return this.t17ProvinciaDao.findAllLike(t17Provincia, pagination, startsWith);
	}

	/**
	 * 
	 * @return T17ProvinciaDao
	 */
	public T17ProvinciaDao getT17ProvinciaDao() {
		return this.t17ProvinciaDao;
	}

	/**
	 * 
	 * @param t17ProvinciaDao
	 *            T17ProvinciaDao
	 */
	public void setT17ProvinciaDao(T17ProvinciaDao t17ProvinciaDao) {
		this.t17ProvinciaDao = t17ProvinciaDao;
	}

	@Override
	public List<T17Provincia> findProvinciasVascas() {
		return this.t17ProvinciaDao.findProvinciasVascas();
	}
}
