package com.ejie.ab59.service.nora;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab59.dao.nora.T17PaisDao;
import com.ejie.ab59.model.nora.T17Pais;
import com.ejie.x38.dto.Pagination;

/**
 * T17PaisServiceImpl  
 * 
 *  
 */
@Service(value = "t17PaisService")
public class T17PaisServiceImpl implements T17PaisService {
	
	@Autowired()
	private T17PaisDao t17PaisDao;

	/**
	 * Finds a single row in the T17Pais table.
	 * 
	 * @param t17Pais
	 *            T17Pais
	 * @return T17Pais
	 */
	public T17Pais find(T17Pais t17Pais) {
		return this.t17PaisDao.find(t17Pais);
	}

	/**
	 * Finds a List of rows in the T17Pais table.
	 * 
	 * @param t17Pais
	 *            T17Pais
	 * @param pagination
	 *            Pagination<Object>
	 * @return List
	 */
	public List<T17Pais> findAll(T17Pais t17Pais, Pagination<Object> pagination) {
		return this.t17PaisDao.findAll(t17Pais, pagination);

	}

	/**
	 * Counts rows in the T17Pais table.
	 * 
	 * @param t17Pais
	 *            T17Pais
	 * @return Long
	 */
	public Long findAllCount(T17Pais t17Pais) {
		return this.t17PaisDao.findAllCount(t17Pais);
	}

	/**
	 * Finds rows in the T17Pais table using like.
	 * 
	 * @param t17Pais
	 *            T17Pais
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Pais>
	 */
	public List<T17Pais> findAllLike(T17Pais t17Pais, Pagination<Object> pagination, Boolean startsWith) {
		return this.t17PaisDao.findAllLike(t17Pais, pagination, startsWith);
	}

	/**
	 * 
	 * @return T17PaisDao
	 */
	public T17PaisDao getT17PaisDao() {
		return this.t17PaisDao;
	}

	/**
	 * 
	 * @param t17PaisDao
	 *            T17PaisDao
	 */
	public void setT17PaisDao(T17PaisDao t17PaisDao) {
		this.t17PaisDao = t17PaisDao;
	}
}
