package com.ejie.ab59.service.nora;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab59.dao.nora.T17MunicipioDao;
import com.ejie.ab59.model.nora.T17Municipio;
import com.ejie.x38.dto.Pagination;

/**
 * T17MunicipioServiceImpl  
 * 
 *  
 */
@Service(value = "t17MunicipioService")
public class T17MunicipioServiceImpl implements T17MunicipioService {
	
	@Autowired()
	private T17MunicipioDao t17MunicipioDao;

	/**
	 * Finds a single row in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return T17Municipio
	 */
	public T17Municipio find(T17Municipio t17Municipio) {
		return this.t17MunicipioDao.find(t17Municipio);
	}

	/**
	 * Finds a List of rows in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination<Object>
	 * @return List
	 */
	public List<T17Municipio> findAll(T17Municipio t17Municipio, Pagination<Object> pagination) {
		return this.t17MunicipioDao.findAll(t17Municipio, pagination);
	}

	/**
	 * Counts rows in the T17Municipio table.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @return Long
	 */
	public Long findAllCount(T17Municipio t17Municipio) {
		return this.t17MunicipioDao.findAllCount(t17Municipio);
	}

	/**
	 * Finds rows in the T17Municipio table using like.
	 * 
	 * @param t17Municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Municipio>
	 */
	public List<T17Municipio> findAllLike(T17Municipio t17Municipio, Pagination<Object> pagination,
			Boolean startsWith) {
		return this.t17MunicipioDao.findAllLike(t17Municipio, pagination, startsWith);
	}

	/**
	 * 
	 * @return T17MunicipioDao
	 */
	public T17MunicipioDao getT17MunicipioDao() {
		return this.t17MunicipioDao;
	}

	/**
	 * 
	 * @param t17MunicipioDao
	 *            T17MunicipioDao
	 */
	public void setT17MunicipioDao(T17MunicipioDao t17MunicipioDao) {
		this.t17MunicipioDao = t17MunicipioDao;
	}
}
