package com.ejie.ab59.service.nora;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab59.dao.nora.T17LocalidadDao;
import com.ejie.ab59.model.nora.T17Localidad;
import com.ejie.x38.dto.Pagination;

/**
 * T17LocalidadServiceImpl  
 * 
 *  
 */
@Service(value = "t17LocalidadService")
public class T17LocalidadServiceImpl implements T17LocalidadService {

	@Autowired()
	private T17LocalidadDao t17LocalidadDao;

	/**
	 * Finds a single row in the T17Localidad table.
	 * 
	 * @param t17Localidad
	 *            T17Localidad
	 * @return T17Localidad
	 */
	public T17Localidad find(T17Localidad t17Localidad) {
		return this.t17LocalidadDao.find(t17Localidad);
	}

	/**
	 * Finds a List of rows in the T17Localidad table.
	 * 
	 * @param t17Localidad
	 *            T17Localidad
	 * @param pagination
	 *            Pagination<Object>
	 * 
	 * @return List<T17Localidad>
	 */
	public List<T17Localidad> findAll(T17Localidad t17Localidad, Pagination<Object> pagination) {
		return this.t17LocalidadDao.findAll(t17Localidad, pagination);
	}

	/**
	 * Counts rows in the T17Localidad table.
	 * 
	 * @param t17Localidad
	 *            T17Localidad
	 * @return Long
	 */
	public Long findAllCount(T17Localidad t17Localidad) {
		return this.t17LocalidadDao.findAllCount(t17Localidad);
	}

	/**
	 * Finds rows in the T17Localidad table using like.
	 * 
	 * @param t17Localidad
	 *            T17Localidad
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<T17Localidad> findAllLike(T17Localidad t17Localidad, Pagination<Object> pagination,
			Boolean startsWith) {
		return this.t17LocalidadDao.findAllLike(t17Localidad, pagination, startsWith);
	}

	/**
	 * 
	 * @return T17LocalidadDao
	 */
	public T17LocalidadDao getT17LocalidadDao() {
		return this.t17LocalidadDao;
	}

	/**
	 * 
	 * @param t17LocalidadDao
	 *            T17LocalidadDao
	 */
	public void setT17LocalidadDao(T17LocalidadDao t17LocalidadDao) {
		this.t17LocalidadDao = t17LocalidadDao;
	}
}
