package com.ejie.ab59.service.listados;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab59.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab59.clientesWS.ab61WebService.BusquedasWS;
import com.ejie.ab59.clientesWS.ab61WebService.ParametrosWS;
import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.model.listados.Listados;
import com.ejie.ab59.webservice.adaptadores.ab61WebServiceAdaptador;

/**
 * 
 *  
 *
 */

@Service(value = "listadosService")
public class ListadosServiceImpl implements ListadosService {

	@Autowired
	private ab61WebServiceAdaptador ab61WebServiceAdaptadorService;

	/**
	 * llama al webService que genera un XLS con las busquedas seleccionadas
	 * 
	 * @param listados
	 *            Lsitados
	 * 
	 * @return string ruta fichero pif
	 */
	public String gerenarXLS(Listados listados, Integer idProcedimiento) throws Ab61Exception {
		List<BusquedasWS> listaBusquedas = new ArrayList<BusquedasWS>();
		if (null != listados && "" != listados.getResultado() && null != listados.getResultado()) {
			// Separamos las diferentes busquedas
			String[] resultadoArray = listados.getResultado().split("&");
			// por cada busqueda separamos id y lista de parametros
			for (int i = 0; i < resultadoArray.length; i++) {
				String[] busquedaParametros = resultadoArray[i].split("#");
				if (busquedaParametros.length >= 1) {
					BusquedasWS busqueda = new BusquedasWS();
					busqueda.setIdBusqueda(Integer.parseInt(busquedaParametros[0]));
					if (busquedaParametros.length > 1) {
						String listaParametros = busquedaParametros[1];
						String[] listaParametrosArray = listaParametros.split(",");
						for (int j = 0; j < listaParametrosArray.length; j++) {
							String[] idValParametro = listaParametrosArray[j].split("@");
							if (idValParametro.length > 1) {
								ParametrosWS parametro = new ParametrosWS();
								parametro.setIdParametro(Integer.parseInt(idValParametro[0]));
								parametro.setValor(idValParametro[1]);
								busqueda.getParametros().add(parametro);
							}
						}
					}
					listaBusquedas.add(busqueda);
				}
			}
		}

		return ab61WebServiceAdaptadorService.generarExcelListados(listados.getIdListado(), listaBusquedas,
				Constantes.CODIGO_APLICACION, idProcedimiento);
	}
}
