package com.ejie.ab59.service.listados;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.listados.BusquedasDao;
import com.ejie.ab59.dao.listados.ParametrosDao;
import com.ejie.ab59.model.listados.Busquedas;
import com.ejie.ab59.model.listados.Parametros;

/**
 * 
 *  
 *
 */

@Service(value = "busquedasService")
public class BusquedasServiceImpl implements BusquedasService {

	@Autowired
	private BusquedasDao busquedasDao;
	@Autowired
	private ParametrosDao parametrosDao;

	/**
	 * Finds rows in the Busquedas table using like.
	 *
	 * @param filterBusquedas
	 *            Busquedas
	 * 
	 * @return List<Busquedas>
	 */
	@Transactional(readOnly = true)
	public List<Busquedas> findByListado(Busquedas filterBusquedas) {

		List<Busquedas> listaBusquedas = this.busquedasDao.findByListado(filterBusquedas);
		List<Busquedas> resultado = new ArrayList<Busquedas>();
		for (Busquedas busquedas : listaBusquedas) {
			Parametros filterParametros = new Parametros();
			filterParametros.setBusqueda(busquedas);
			List<Parametros> listaParametros = this.parametrosDao.findByBusqueda(filterParametros);
			busquedas.setListaParametros(listaParametros);
			resultado.add(busquedas);
		}
		return resultado;
	}
}
