package com.ejie.ab59.service.expedientes;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

import com.ejie.ab59.comun.Constantes;
import com.ejie.ab59.dao.expedientes.CanalesAvisoDao;
import com.ejie.ab59.dao.expedientes.DatosDireccionesDao;
import com.ejie.ab59.dao.expedientes.ExpedientesDao;
import com.ejie.ab59.dao.expedientes.RelExpTerDao;
import com.ejie.ab59.model.expedientes.CanalesAviso;
import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.DatosTerceros;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.expedientes.RelExpTer;
import com.ejie.ab59.model.expedientes.TiposTercero;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */
@Service(value = "relExpTerService")
public class RelExpTerServiceImpl implements RelExpTerService {

	@Autowired
	private ExpedientesDao expedientesDao;
	@Autowired
	private RelExpTerDao relExpTerDao;
	@Autowired
	private DatosDireccionesDao datosDireccionesDao;
	@Autowired
	private CanalesAvisoDao canalesAvisoDao;

	/**
	 * Finds a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	@Override
	public Expedientes findIdExpediente(Expedientes expedientes) {
		return this.expedientesDao.findIdExpediente(expedientes);
	}

	/**
	 * busco el expediente asociado a la sanción
	 *
	 * @param idSancion
	 *            Integer
	 * 
	 * @return Expedientes
	 */
	@Override
	public Expedientes findExpedienteSancion(Integer idSancion) {
		return this.expedientesDao.findExpedienteSancion(idSancion);
	}

	/**
	 * Obtener lista de participaciones y direcciones del solicitante titular
	 * 
	 * 
	 * @param idExpediente
	 *            Integer
	 * 
	 */
	@Override
	public List<RelExpTer> findParticipaciones(Integer idExpediente, Model model) {
		List<RelExpTer> listaParticipantes = this.relExpTerDao.findParticipantes(idExpediente);

		// Participacin SOLICITANTE (PARTICIPANT_ID) -> Tipo Tercero = 1
		// -Titular
		// -Representate
		// -Otros Interesados
		// Participacin AFECTADO (PARTICIPANT_ID) -> Tipo Tercero = 3
		// -Titular
		// -Representate
		// -Otros Interesados
		// REPERESETANTE LEGAL -> Tipo Tercero = 6
		// PERSONA CONTACTO -> Tipo Tercero = 2
		// DENUNCIADO PROVISIONAL -> Tipo Tercero = 7

		List<RelExpTer> listaParticipaciones = new ArrayList<RelExpTer>();
		List<RelExpTer> listaParticipacionesParteInculpada = new ArrayList<RelExpTer>();
		String participantIdAnterior = "";
		TiposTercero tipoTerceroAnterior = new TiposTercero();

		RelExpTer participacion = null;
		List<DatosTerceros> listaParticipantesParticipacion = null;

		for (int contadorParticipante = 0; contadorParticipante < listaParticipantes.size(); contadorParticipante++) {

			RelExpTer participante = listaParticipantes.get(contadorParticipante);

			// Si tenemos una PARTICIPACIN de DIFERENTE tipo a la anterior hay
			// que crear una participacin nueva
			// Si tenemos la misma PARTICIPACIN pero con PARTICIPANT_ID
			// DIFERENTE tambin tenemos que crear una participacin nueva
			if ((listaParticipantes.get(contadorParticipante).getTipoTercero().getIdTipoTercero() != tipoTerceroAnterior
					.getIdTipoTercero())
					|| (participante.getTipoTercero().getIdTipoTercero() == tipoTerceroAnterior.getIdTipoTercero()
							&& participante.getParticipantId() != null
							&& !participante.getParticipantId().equals(participantIdAnterior))) {
				if (participacion != null) {
					listaParticipaciones.add(participacion);
				}
				participacion = new RelExpTer();
				listaParticipantesParticipacion = new ArrayList<DatosTerceros>();
			}

			tipoTerceroAnterior.setIdTipoTercero(participante.getTipoTercero().getIdTipoTercero());
			participantIdAnterior = participante.getParticipantId();

			DatosTerceros datosTercero = new DatosTerceros();

			datosTercero.setIdTercero(participante.getDatosTercero().getIdTercero());
			datosTercero.setDocumento(participante.getDatosTercero().getDocumento());
			datosTercero.setTipoDocumento(participante.getDatosTercero().getTipoDocumento());
			String nombre = "";
			if (participante.getDatosTercero().getNombre() != null) {
				nombre = participante.getDatosTercero().getNombre().replaceAll("[\"]", "");
			}
			String apellido1 = "";
			if (participante.getDatosTercero().getApellido1() != null) {
				apellido1 = participante.getDatosTercero().getApellido1().replaceAll("[\"]", "");
			}
			String apellido2 = "";
			if (participante.getDatosTercero().getApellido2() != null) {
				apellido2 = participante.getDatosTercero().getApellido2().replaceAll("[\"]", "");
			}

			datosTercero.setNombre(nombre);
			datosTercero.setApellido1(apellido1);
			datosTercero.setApellido2(apellido2);
			datosTercero.setTipoParticipante(participante.getDatosTercero().getTipoParticipante());
			if (participante.getDatosTercero().getDatosDirecciones().getIdDireccion() != null) {
				if (participante.getDatosTercero().getTipoParticipante() == Constantes.PARTICIPANTE_REPRESENTANTE) {
					participacion.setTipoParticipanteCastellano(Constantes.REPRESENTANTE_CAS);
					participacion.setTipoParticipanteEuskera(Constantes.REPRESENTANTE_EUS);

				} else {
					participacion.setTipoParticipanteCastellano(Constantes.TITULAR_CAS);
					participacion.setTipoParticipanteEuskera(Constantes.TITULAR_EUS);
				}
				participacion.setUbicacionDireccionPostal(participante.getDatosTercero().getDatosDirecciones());
			}

			listaParticipantesParticipacion.add(datosTercero);

			participacion.setIdRelExpTer(participante.getIdRelExpTer());
			participacion.setParticipantId(participante.getParticipantId());
			participacion.setIdTipoParticipacion(participante.getTipoTercero().getIdTipoTercero());
			participacion.setTipoParticipacionCastellano(participante.getTipoTercero().getDescripcionCastellano());
			participacion.setTipoParticipacionEuskera(participante.getTipoTercero().getDescripcionEuskera());
			if (participacion.getIdSubtipoParticipacion() == null) {
				if (participante.getSubtipoTercero() != null) {
					participacion.setIdSubtipoParticipacion(participante.getSubtipoTercero().getIdSubtipoTercero());
					participacion.setSubtipoParticipacionCastellano(
							participante.getSubtipoTercero().getDescripcionCastellano());
					participacion
							.setSubtipoParticipacionEuskera(participante.getSubtipoTercero().getDescripcionEuskera());

					if (participacion.getIdSubtipoParticipacion() == Constantes.PARTE_INCULPADA) {
						listaParticipacionesParteInculpada.add(participacion);
					}

				}
			}

			participacion.setListaDatosTerceros(listaParticipantesParticipacion);
			if (contadorParticipante == listaParticipantes.size() - 1) {
				if (participacion != null) {
					listaParticipaciones.add(participacion);
				}
			}
		}

		/*
		 * Nos recorremos las participaciones parte inculpada del expediente. Si
		 * tenemos titular y representante comprobamos si el representante tiene
		 * direccin postal o canal aviso email Si slo tenemos titular
		 * comprobamos los mismos datos para el titular. Si alguna de las
		 * participaciones no dispone de alguno de estos datos mostramos mensaje
		 * de error.
		 */
		boolean parteInculpadaSinDatosAviso = false;
		for (RelExpTer participacionParteInculpada : listaParticipacionesParteInculpada) {
			if (parteInculpadaSinDatosAviso) {
				break;
			}
			List<DatosTerceros> tercerosTitularesRepresentantes = new ArrayList<DatosTerceros>();
			for (DatosTerceros tercero : participacionParteInculpada.getListaDatosTerceros()) {
				if (tercero.getTipoParticipante() == Constantes.PARTICIPANTE_TITULAR
						|| tercero.getTipoParticipante() == Constantes.PARTICIPANTE_REPRESENTANTE) {
					tercerosTitularesRepresentantes.add(tercero);
				}
			}
			participacionParteInculpada.setListaDatosTerceros(tercerosTitularesRepresentantes);

			if (participacionParteInculpada.getListaDatosTerceros().size() > 1) {
				// Tiene algn representante
				for (DatosTerceros datosTercero : participacionParteInculpada.getListaDatosTerceros()) {
					if (datosTercero.getTipoParticipante() == Constantes.PARTICIPANTE_REPRESENTANTE) {
						CanalesAviso canalAviso = this.canalesAvisoDao.findByTerceroTipoCanalAviso(datosTercero,
								Constantes.TIPO_CANAL_AVISO_EMAIL);
						DatosDirecciones direccionPostal = this.datosDireccionesDao
								.findDireccionByTerceroTipoDireccion(datosTercero, Constantes.DIRECCION_CANAL_POSTAL);

						if (canalAviso == null && direccionPostal == null) {
							// Sacamos mensaje
							parteInculpadaSinDatosAviso = true;
							break;
						}

					}
				}

			} else if (participacionParteInculpada.getListaDatosTerceros().size() == 1) {
				// Slo tiene un titular
				DatosTerceros datosTercero = participacionParteInculpada.getListaDatosTerceros().get(0);
				CanalesAviso canalAviso = this.canalesAvisoDao.findByTerceroTipoCanalAviso(datosTercero,
						Constantes.TIPO_CANAL_AVISO_EMAIL);
				DatosDirecciones direccionPostal = this.datosDireccionesDao
						.findDireccionByTerceroTipoDireccion(datosTercero, Constantes.DIRECCION_CANAL_POSTAL);

				if (canalAviso == null && direccionPostal == null) {
					// Sacamos mensaje
					parteInculpadaSinDatosAviso = true;
					break;
				}
			}
		}

		model.addAttribute("parteInculpadaSinDatosAviso", parteInculpadaSinDatosAviso);

		return listaParticipaciones;

	}

	/**
	 * Update tipo de una relacion
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	@Override
	public RelExpTer updateSubtipo(RelExpTer relexpter) {
		return this.relExpTerDao.updateSubtipo(relexpter);
	}

	/**
	 * Filter method in the RelExpTer table.
	 *
	 * @param filterRelExpTer
	 *            RelExpTer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<RelExpTer>
	 */
	@Override
	public TableResponseDto<RelExpTer> filterByExpediente(RelExpTer filterRelExpTer, TableRequestDto tableRequestDto) {

		List<RelExpTer> listaRelExpTer = this.relExpTerDao.findAllByExpediente(filterRelExpTer, tableRequestDto);
		Long recordNum = this.relExpTerDao
				.findAllByExpedienteCount(filterRelExpTer != null ? filterRelExpTer : new RelExpTer());

		return new TableResponseDto<RelExpTer>(tableRequestDto, recordNum, listaRelExpTer);
	}

	@Override
	public TableResponseDto<RelExpTer> filterSinExpediente(RelExpTer filterRelExpTer, TableRequestDto tableRequestDto) {
		List<RelExpTer> listaRelExpTer = this.relExpTerDao.findAllSinExpediente(filterRelExpTer, tableRequestDto);
		Long recordNum = this.relExpTerDao
				.findAllSinExpedienteCount(filterRelExpTer != null ? filterRelExpTer : new RelExpTer());

		return new TableResponseDto<RelExpTer>(tableRequestDto, recordNum, listaRelExpTer);
	}
}
