package com.ejie.ab59.service.expedientes;

import java.util.List;

import org.springframework.ui.Model;

import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.model.expedientes.RelExpTer;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * 
 *  
 *
 */

public interface RelExpTerService {

	/**
	 * Finds a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes findIdExpediente(Expedientes expedientes);

	/**
	 * busco el expediente asociado a la sanción
	 *
	 * @param idSancion
	 *            Integer
	 * 
	 * @return Expedientes
	 */
	Expedientes findExpedienteSancion(Integer idSancion);

	/**
	 * Obtener lista de participaciones y direcciones del solicitante titular
	 * 
	 * 
	 * @param idExpediente
	 *            Integer
	 * @param model
	 * 
	 */
	List<RelExpTer> findParticipaciones(Integer idExpediente, Model model);

	/**
	 * Update tipo de una relacion
	 *
	 * @param relexpter
	 *            RelExpTer
	 * @return RelExpTer
	 */
	RelExpTer updateSubtipo(RelExpTer relexpter);

	/**
	 * Filter method in the RelExpTer table.
	 *
	 * @param filterRelExpTer
	 *            RelExpTer
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<RelExpTer>
	 */
	TableResponseDto<RelExpTer> filterByExpediente(RelExpTer filterRelExpTer, TableRequestDto tableRequestDto);

	TableResponseDto<RelExpTer> filterSinExpediente(RelExpTer filterRelExpTer, TableRequestDto tableRequestDto);
}
