package com.ejie.ab59.service.expedientes;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.expedientes.DatosDireccionesDao;
import com.ejie.ab59.dao.expedientes.RelExpDirDao;
import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.RelExpDir;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * RelSanProSanServiceImpl  
 * 
 *  
 */

@Service(value = "relExpDirService")
public class RelExpDirServiceImpl implements RelExpDirService {

	@Autowired
	private RelExpDirDao relExpDirDao;

	@Autowired
	private DatosDireccionesDao datosDireccionesDao;

	/*
	 * OPERACIONES RUP_TABLE
	 */
	/**
	 * Filter method in the RelSanProSan table.
	 *
	 * @param filterRelExpDir
	 *            RelExpDir
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return TableResponseDto<RelExpDir>
	 */
	public TableResponseDto<RelExpDir> filter(RelExpDir filterRelExpDir, TableRequestDto tableRequestDto) {
		List<RelExpDir> listaRelExpDir = this.relExpDirDao.findAll(filterRelExpDir, tableRequestDto);
		Long recordNum = this.relExpDirDao.findAllCount(filterRelExpDir != null ? filterRelExpDir : new RelExpDir());

		return new TableResponseDto<RelExpDir>(tableRequestDto, recordNum, listaRelExpDir);
	}

	/**
	 * Updates a single row in the PropuestasSancion table.
	 *
	 * @param relExpDir
	 *            RelExpDir
	 * @return RelExpDir
	 */
	// @Transactional(rollbackFor = Throwable.class)
	// public RelExpDir update(RelExpDir relExpDir) {
	//
	// return this.relExpDirDao.update(relExpDir);
	// }

	/**
	 * Deletes a single row in the RelSanProSan table.
	 *
	 * @param relSanProSan
	 *            RelSanProSan
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RelExpDir relExpDir) {

		DatosDirecciones datosDirecciones = new DatosDirecciones();
		datosDirecciones.setIdDireccion(relExpDir.getIdDireccion());
		this.relExpDirDao.remove(relExpDir);
		this.datosDireccionesDao.remove(datosDirecciones);

	}

}
