package com.ejie.ab59.service.expedientes;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.clientesWS.ab61WebService.Exception_Exception;
import com.ejie.ab59.dao.expedientes.ExpedientesDao;
import com.ejie.ab59.model.expedientes.Expedientes;
import com.ejie.ab59.webservice.adaptadores.ab61WebServiceAdaptador;

/**
 * ExpedientesServiceImpl  
 * 
 *  
 */

@Service(value = "expedientesService")
public class ExpedientesServiceImpl implements ExpedientesService {

	private static final Logger logger = LoggerFactory.getLogger(ExpedientesServiceImpl.class);

	@Autowired
	private ExpedientesDao expedientesDao;

	@Autowired
	private ab61WebServiceAdaptador ab61WebServiceAdaptadorService;
	
	public Expedientes findIdExpediente(Expedientes expedientes) {
		return this.expedientesDao.findIdExpediente(expedientes);
	}

	public Expedientes findExpedienteSancion(Integer idSancion) {
		return this.expedientesDao.findExpedienteSancion(idSancion);
	}

	@Transactional
	@Override
	public boolean actualizarParticipaciones(String folderId, String usuario) throws Exception_Exception {

		ExpedientesServiceImpl.logger.info("Entrada a actualizarParticipaciones");
		return this.ab61WebServiceAdaptadorService.actualizarParticipaciones(folderId, usuario);
	}

	public Expedientes findUrlFromFolderNumber(String folderId) {

		return this.expedientesDao.findUrlFromFolderNumber(folderId);
	}

	@Override
	public boolean findExpedienteCerrado(Expedientes expediente) {
		return this.expedientesDao.findExpedienteCerrado(expediente);
	}
}
