package com.ejie.ab59.service.expedientes;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab59.dao.expedientes.DatosDireccionesDao;
import com.ejie.ab59.dao.expedientes.RelExpDirDao;
import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.RelExpDir;

/**
 * 
 *  
 *
 */
@Service(value = "datosDireccionesService")
public class DatosDireccionesServiceImpl implements DatosDireccionesService {

	@Autowired
	private DatosDireccionesDao datosDireccionesDao;

	@Autowired
	private RelExpDirDao relExpDirDao;

	/**
	 * Borrar la dirección de una sanción
	 *
	 * @param idTercero
	 *            Integer
	 * @return
	 */
	public void removeDireccionesTerceroPostal(Integer idTercero) {

		this.datosDireccionesDao.removeDireccionesTerceroPostal(idTercero);
	}

	/**
	 * Buscar la dirección asociada a la sanción
	 *
	 * @param idSancion
	 *            Integer
	 * 
	 * @return DatosDirecciones
	 */
	@Transactional(readOnly = true)
	public DatosDirecciones findDireccion(Integer idSancion) {
		return this.datosDireccionesDao.findDireccion(idSancion);
	}

	/**
	 * Updates a single row in the Sanciones table.
	 *
	 * @param datosDireccion
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	public DatosDirecciones updateUbicacion(DatosDirecciones datosDireccion) {
		return this.datosDireccionesDao.updateUbicacion(datosDireccion);
	}

	/**
	 * Updates a single row in the Sanciones table.
	 *
	 * @param relExpDir
	 *            RelExpDir
	 * @return RelExpDir
	 */
	public RelExpDir insertUbicacion(RelExpDir relExpDir) {

		DatosDirecciones datosDireccionesAux = this.datosDireccionesDao.add(relExpDir.getDatosDirecciones());
		relExpDir.setIdDireccion(datosDireccionesAux.getIdDireccion());
		RelExpDir relExpDirAux = this.relExpDirDao.add(relExpDir);

		return relExpDirAux;
	}

	@Override
	public DatosDirecciones buscarEstablecimiento(String numeroRegistro) {
		return this.datosDireccionesDao.buscarEstablecimiento(numeroRegistro);
	}
}
