package com.ejie.ab59.service.expedientes;

import com.ejie.ab59.model.expedientes.DatosDirecciones;
import com.ejie.ab59.model.expedientes.RelExpDir;

/**
 * 
 *  
 *
 */

public interface DatosDireccionesService {

	/**
	 * Borrar la dirección de una sanción
	 *
	 * @param idTercero
	 *            Integer
	 * @return
	 */
	void removeDireccionesTerceroPostal(Integer idTercero);

	/**
	 * Buscar la dirección asociada a la sanción
	 *
	 * @param idSancion
	 *            Integer
	 * 
	 * @return DatosDirecciones
	 */
	DatosDirecciones findDireccion(Integer idSancion);

	/**
	 * Updates a single row in the Sanciones table.
	 *
	 * @param datosDireccion
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	DatosDirecciones updateUbicacion(DatosDirecciones datosDireccion);

	/**
	 * Updates a single row in the Sanciones table.
	 *
	 * @param relExpDir
	 *            RelExpDir relExpDir
	 * @return RelExpDir relExpDir
	 */
	RelExpDir insertUbicacion(RelExpDir relExpDir);

	DatosDirecciones buscarEstablecimiento(String numeroRegistro);
}
